/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.linkdirectory.theme;

import java.util.ArrayList;
import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.tag.AbstractTagsDAO;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;

/**
 * DAO for manipulating themes
 */
public class ThemesDAO extends AbstractTagsDAO
{
    /** The avalon role */
    public static final String ROLE = ThemesDAO.class.getName();

    /** The JCR Themes DAO */
    protected JCRThemesDAO _jcrThemesDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _jcrThemesDAO = (JCRThemesDAO) manager.lookup(JCRThemesDAO.ROLE);
    }
    
    @Override
    public String getTagProviderEPRole()
    {
        return ThemeProviderExtensionPoint.ROLE;
    }
    
    @Override
    protected AbstractJCRTagsDAO _getTagJCRDAO()
    {
        return _jcrThemesDAO;
    }

    @Override
    protected List<TagProvider< ? extends Tag>> getCustomTagProvider()
    {
        List<TagProvider<? extends Tag>> providers = new ArrayList<>();
        providers.add(_tagProviderExtPt.getExtension(JCRThemeProvider.class.getName()));
        
        return providers;
    }
}
