/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * {@link} Ext.view.View listing the items of the map
 * @private
 */
Ext.define('Ametys.plugins.maps.MapItemsView', {
	extend: 'Ext.view.View',
	
	constructor: function(config)
	{
		var width = config.width || 200;
		Ext.applyIf (config, {
			border: false,
			
			multiSelect: false,
            itemSelector: 'div.map-item-selector',
            overItemCls:'map-item-selector-over',
            emptyText: '',
            deferEmptyText: false,
		    
		    tpl: new Ext.XTemplate(
	    		'<tpl for=".">',
				    '<div class="map-item-selector" style="display:table">',
                        '<div class="map-item-title" title="{title}" style="display: table-cell; width: 100%">',
                             '<tpl if="this.isGMarker(gtype)">',
                                '<span class="map-item-icon ametysicon-placeholder19"></span>',
                             '</tpl>',             
                             '<tpl if="this.isGShape(gtype)">',
                                '<span class="map-item-icon ametysicon-shape"></span>',
                             '</tpl>',
                             '{shortTitle}',
                         '</div>',
			            '<div class="item-action-container" style="display: table-cell; ">',
                            '<span class="map-item-action ametysicon-edit45" onClick="Ametys.plugins.maps.MapServiceActions._gMapConfiguration.editItemAtIndex(\'{recordId}\')"></span>',             
			                '<span class="map-item-action ametysicon-delete30"onClick="Ametys.plugins.maps.MapServiceActions._gMapConfiguration.removeItemAtIndex(\'{recordId}\')"></span>',
                        '</div>',             
		            '</div>',
			         '<div style="clear:left"></div>',             
		         '</tpl>',
		         {
	                // XTemplate configuration:
	                compiled: true,
	                disableFormats: true,
	                // member functions:
	                isGMarker: function(gtype){
	                    return gtype === 'marker';
	                },
	                isGShape: function(gtype){
	                    return gtype === 'polygon';
	                }
	            }
	   		)
		});
		
		this.callParent(arguments);
	}
});

