/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class FeedHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FeedHelper.class.getName();
    protected I18nUtils _i18nUtils;
    protected ProjectsCatalogueManager _projectsCatalogueManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        if (PluginsManager.getInstance().isPluginActive("workspaces")) {
            this._projectsCatalogueManager = (ProjectsCatalogueManager)manager.lookup(ProjectsCatalogueManager.ROLE);
        }
    }

    public Map<String, Map<String, Object>> getProjects() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (this._projectsCatalogueManager != null) {
            List userProjects = this._projectsCatalogueManager.getUserProjects();
            for (Map fullProjectMap : userProjects) {
                String name = (String)fullProjectMap.get("name");
                HashMap<String, String> neededInfos = new HashMap<String, String>();
                neededInfos.put("name", name);
                neededInfos.put("description", (String)fullProjectMap.get("description"));
                neededInfos.put("title", (String)fullProjectMap.get("title"));
                neededInfos.put("url", (String)fullProjectMap.get("url"));
                neededInfos.put("illustration", (String)fullProjectMap.get("illustration"));
                neededInfos.put("language", (String)fullProjectMap.get("language"));
                neededInfos.put("id", (String)fullProjectMap.get("id"));
                neededInfos.put("category", (String)fullProjectMap.get("category"));
                result.put(name, neededInfos);
            }
        }
        return result;
    }

    public Map<String, Object> projectToMap(Project project) {
        return this._projectsCatalogueManager.detailedProject2json(project);
    }

    public Map<String, Object> getActivityInfos(Map<String, Object> activity, Map<String, Object> project, String lang) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(activity);
        result.put("project", project);
        Map activityAuthor = (Map)activity.get("author");
        HashMap<String, String> author = new HashMap<String, String>();
        author.put("fullname", (String)activityAuthor.get("fullname"));
        result.put("author", author);
        result.put("short-description", this.getActivityDescription(activity, lang));
        result.put("content_id", this.getActivityObjectId(activity));
        result.put("content_url", this.getActivityUrl(activity));
        return result;
    }

    protected String getActivityObjectId(Map<String, Object> activity) {
        String eventType;
        String id = null;
        switch (eventType = (String)activity.get("type")) {
            case "resource.created": 
            case "resource.updated": 
            case "resource.renamed": {
                if (!activity.containsKey("file")) break;
                id = (String)((Map)activity.get("file")).get("id");
                break;
            }
            case "calendar.event.created": 
            case "calendar.event.updated": {
                id = (String)activity.get("eventId");
                break;
            }
            case "forumthread.created": 
            case "forumthread.commented": {
                id = (String)activity.get("threadId");
                break;
            }
            case "member.added": {
                break;
            }
            case "wallcontent.added": {
                id = (String)activity.get("contentId");
                break;
            }
            case "minisite.page.created": 
            case "minisite.page.updated": 
            case "minisite.page.renamed": 
            case "minisite.page.deleted": {
                id = (String)activity.get("pageId");
                break;
            }
            case "task.created": 
            case "task.assigned": 
            case "task.closed.status.changed": {
                id = (String)activity.get("taskId");
                break;
            }
        }
        return id;
    }

    protected String getActivityUrl(Map<String, Object> activity) {
        String eventType;
        String url = null;
        switch (eventType = (String)activity.get("type")) {
            case "resource.created": 
            case "resource.updated": 
            case "resource.renamed": {
                url = (String)activity.get("parentFolderUrl");
                break;
            }
            case "calendar.event.created": 
            case "calendar.event.updated": {
                url = (String)activity.get("eventUrl");
                break;
            }
            case "forumthread.created": 
            case "forumthread.commented": {
                url = (String)activity.get("threadUrl");
                break;
            }
            case "member.added": {
                break;
            }
            case "wallcontent.added": {
                break;
            }
            case "minisite.page.created": 
            case "minisite.page.updated": 
            case "minisite.page.renamed": 
            case "minisite.page.deleted": {
                url = (String)activity.get("pageUrl");
                break;
            }
            case "task.created": 
            case "task.assigned": 
            case "task.closed.status.changed": {
                url = (String)activity.get("taskUrl");
                break;
            }
        }
        if (StringUtils.isBlank(url)) {
            url = (String)activity.get("projectUrl");
        }
        return url;
    }

    protected String getActivityDescription(Map<String, Object> activity, String lang) {
        String description = null;
        String eventType = (String)activity.get("type");
        Integer amount = (Integer)activity.get("amount");
        if (amount == null) {
            amount = 1;
        }
        String i18nKey = null;
        HashMap<String, I18nizableText> parameters = new HashMap<String, I18nizableText>();
        parameters.put("author", new I18nizableText((String)((Map)activity.get("author")).get("fullname")));
        parameters.put("project", new I18nizableText((String)activity.get("projectTitle")));
        parameters.put("nb", new I18nizableText(amount.toString()));
        switch (eventType) {
            case "resource.created": {
                parameters.put("folder", new I18nizableText((String)activity.get("parentFolder")));
                if (amount == 1) {
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_ADDED_DESC";
                    break;
                }
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_ADDED_MULTI_DESC";
                break;
            }
            case "resource.updated": {
                parameters.put("folder", new I18nizableText((String)activity.get("parentFolder")));
                if (amount == 1) {
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_UPDATED_DESC";
                    break;
                }
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_UPDATED_MULTI_DESC";
                break;
            }
            case "resource.renamed": {
                parameters.put("folder", new I18nizableText((String)activity.get("parentFolder")));
                if (amount == 1) {
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_RENAMED_DESC";
                    break;
                }
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_DOCUMENT_RENAMED_MULTI_DESC";
                break;
            }
            case "calendar.event.created": {
                parameters.put("calendar", new I18nizableText((String)activity.get("calendarTitle")));
                if (amount == 1) {
                    parameters.put("event", new I18nizableText(this.getTitles(activity, "events", "eventTitle")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_ADDED_DESC";
                    break;
                }
                parameters.put("events", new I18nizableText(this.getTitles(activity, "events", "eventTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_ADDED_MULTI_DESC";
                break;
            }
            case "calendar.event.updated": {
                parameters.put("calendar", new I18nizableText((String)activity.get("calendarTitle")));
                if (amount == 1) {
                    parameters.put("event", new I18nizableText(this.getTitles(activity, "events", "eventTitle")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_UPDATED_DESC";
                    break;
                }
                parameters.put("events", new I18nizableText(this.getTitles(activity, "events", "eventTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CALENDAR_UPDATED_MULTI_DESC";
                break;
            }
            case "forumthread.created": {
                if (amount == 1) {
                    parameters.put("thread", new I18nizableText(this.getTitles(activity, "threads", "threadTitle")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_THREAD_CREATED_DESC";
                    break;
                }
                parameters.put("threads", new I18nizableText(this.getTitles(activity, "threads", "threadTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_THREAD_CREATED_MULTI_DESC";
                break;
            }
            case "forumthread.commented": {
                parameters.put("thread", new I18nizableText(this.getTitles(activity, "threads", "threadTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_THREAD_POST_CREATED_DESC";
                break;
            }
            case "member.added": {
                if (amount == 1) {
                    parameters.put("member", new I18nizableText((String)activity.get("member")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_MEMBER_ADDED_DESC";
                    break;
                }
                Collection members = (Collection)activity.get("members");
                List names = members.stream().map(member -> (String)member.get("name")).collect(Collectors.toList());
                parameters.put("members", new I18nizableText(String.join((CharSequence)", ", names)));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_MEMBERS_ADDED_DESC";
                break;
            }
            case "minisite.page.created": {
                if (amount == 1) {
                    parameters.put("page", new I18nizableText(this.getTitles(activity, "pages", "pageTitle")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGE_CREATED_DESC";
                    break;
                }
                parameters.put("pages", new I18nizableText(this.getTitles(activity, "pages", "pageTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGES_CREATED_DESC";
                break;
            }
            case "minisite.page.updated": {
                if (amount == 1) {
                    parameters.put("page", new I18nizableText(this.getTitles(activity, "pages", "pageTitle")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGE_UPDATED_DESC";
                    break;
                }
                parameters.put("pages", new I18nizableText(this.getTitles(activity, "pages", "pageTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGES_UPDATED_DESC";
                break;
            }
            case "minisite.page.renamed": {
                parameters.put("oldTitle", new I18nizableText((String)activity.get("pageOldTitle")));
                parameters.put("title", new I18nizableText((String)activity.get("pageTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGE_RENAMED_DESC";
                break;
            }
            case "minisite.page.deleted": {
                if (amount == 1) {
                    parameters.put("page", new I18nizableText(this.getTitles(activity, "pages", "pageTitle")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGE_DELETED_DESC";
                    break;
                }
                parameters.put("pages", new I18nizableText(this.getTitles(activity, "pages", "pageTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PAGES_DELETED_DESC";
                break;
            }
            case "project.news.published": {
                parameters.put("contentTitle", new I18nizableText((String)activity.get("contentTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_PROJECT_NEWS_ADDED_DESC";
                break;
            }
            case "wallcontent.added": {
                parameters.put("contentSummary", new I18nizableText((String)activity.get("contentSummary")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_WALLCONTENT_ADDED_WITH_TITLE_DESC";
                break;
            }
            case "content.comment.validated": {
                parameters.put("contentTitle", new I18nizableText((String)activity.get("contentTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_CONTENT_COMMENT_VALIDATED_DESC";
                break;
            }
            case "task.created": {
                if (amount == 1) {
                    parameters.put("task", new I18nizableText(this.getTitles(activity, "tasks", "taskTitle")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_ADDED_DESC";
                    break;
                }
                parameters.put("tasks", new I18nizableText(this.getTitles(activity, "tasks", "taskTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASKS_ADDED_DESC";
                break;
            }
            case "task.deleting": {
                if (amount == 1) {
                    parameters.put("task", new I18nizableText(this.getTitles(activity, "tasks", "taskTitle")));
                    i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_DELETED_DESC";
                    break;
                }
                parameters.put("tasks", new I18nizableText(this.getTitles(activity, "tasks", "taskTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASKS_DELETED_DESC";
                break;
            }
            case "task.assigned": {
                parameters.put("task", new I18nizableText((String)activity.get("taskTitle")));
                parameters.put("assignee", new I18nizableText((String)activity.get("assignees")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_ASSIGNED_DESC";
                break;
            }
            case "task.commented": {
                parameters.put("task", new I18nizableText((String)activity.get("taskTitle")));
                i18nKey = "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_COMMENTED_DESC";
                break;
            }
            case "task.closed.status.changed": {
                parameters.put("task", new I18nizableText((String)activity.get("taskTitle")));
                boolean isClosed = "true".equals(activity.get("isClosed"));
                i18nKey = isClosed ? "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_CLOSED_STATUS_CLOSE_DESC" : "PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_TASK_CLOSED_STATUS_OPEN_DESC";
                break;
            }
        }
        if (i18nKey != null) {
            I18nizableText descriptionI18n = new I18nizableText("plugin.workspaces", i18nKey, parameters);
            description = this._i18nUtils.translate((I18nizable)descriptionI18n, lang);
        }
        return description;
    }

    protected String getTitles(Map<String, Object> activity, String mapKey, String titleKey) {
        List items = (List)activity.get(mapKey);
        if (items == null) {
            return (String)activity.get(titleKey);
        }
        Object result = null;
        for (Map item : items) {
            if (result == null) {
                result = (String)item.get(titleKey);
                continue;
            }
            result = (String)result + ", " + (String)item.get(titleKey);
        }
        return result;
    }
}

