/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.core.impl.authentication.FormCredentialProvider;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetTokenAction
extends ServiceableAction {
    protected AuthenticationTokenManager _authenticationTokenManager;
    protected UserPopulationDAO _userPopulationDAO;
    protected PopulationContextHelper _populationContextHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._authenticationTokenManager = (AuthenticationTokenManager)smanager.lookup(AuthenticationTokenManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)smanager.lookup(PopulationContextHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (this._currentUserProvider.getUser() != null) {
            String generateToken = this._authenticationTokenManager.generateToken(0L, "mobileapp", "Token for the mobile app");
            result.put("code", 200);
            result.put("token", generateToken);
        } else {
            String body = null;
            HttpServletRequest postReq = (HttpServletRequest)objectModel.get("httprequest");
            try (ServletInputStream postBody = postReq.getInputStream();){
                body = new String(postBody.readAllBytes(), StandardCharsets.UTF_8);
            }
            Map jsonParams = this._jsonUtils.convertJsonToMap(body);
            String login = (String)this.getParameter("login", jsonParams, request);
            String password = (String)this.getParameter("password", jsonParams, request);
            String population = (String)this.getParameter("population", jsonParams, request);
            boolean authenticated = false;
            if (StringUtils.isNotBlank((CharSequence)login)) {
                UserPopulation userPopulation = population != null ? this._userPopulationDAO.getUserPopulation(population) : null;
                authenticated = userPopulation != null ? this.authenticate(login, password, request, resolver, parameters, userPopulation, userPopulation.getCredentialProviders()) : this.authenticate(login, password, request, resolver, parameters);
            }
            if (authenticated) {
                String generateToken = this._authenticationTokenManager.generateToken(0L, "mobileapp", "Token for the mobile app");
                result.put("code", 200);
                result.put("token", generateToken);
                this._currentUserProvider.logout(null);
            } else {
                result.put("code", 403);
                throw new AccessDeniedException();
            }
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private Object getParameter(String name, Map<String, Object> jsonParams, Request request) {
        if (jsonParams.containsKey(name)) {
            return jsonParams.get(name);
        }
        if (request.getParameter(name) != null) {
            return request.getParameter(name);
        }
        return request.getAttribute(name);
    }

    private boolean authenticate(String login, String password, Request request, SourceResolver resolver, Parameters parameters) throws ParameterException {
        String siteName = parameters.getParameter("site");
        List<CallSite> populationContexts = List.of("/sites/" + siteName, "/sites-fo/" + siteName);
        boolean atLeastOneAvailablePopulation = false;
        for (String string : populationContexts) {
            Map populations = this._populationContextHelper.getUserPopulationsOnContexts(List.of(string), false, false).stream().map(arg_0 -> ((UserPopulationDAO)this._userPopulationDAO).getUserPopulation(arg_0)).collect(Collectors.toMap(Function.identity(), u -> u.getCredentialProviders()));
            for (Map.Entry entry : populations.entrySet()) {
                atLeastOneAvailablePopulation = this._tryConnect(login, password, request, resolver, string, (UserPopulation)entry.getKey(), entry.getValue()) || atLeastOneAvailablePopulation;
            }
            if (atLeastOneAvailablePopulation) continue;
            this.getLogger().error("Error while logging-in from the mobile application to the '" + siteName + "' site. At least one population should be configured with a form credential provider.");
        }
        return this._currentUserProvider.getUser() != null;
    }

    private boolean _tryConnect(String login, String password, Request request, SourceResolver resolver, String context, UserPopulation userPopulation, List<CredentialProvider> providers) {
        boolean atLeastOneAvailablePopulation = false;
        for (int i = 0; i < providers.size(); ++i) {
            CredentialProvider credentialProvider = providers.get(i);
            if (!(credentialProvider instanceof FormCredentialProvider)) continue;
            try {
                request.setAttribute("Runtime:RequestAuthenticated", (Object)"false");
                String loginParameters = "Username=" + URIUtils.encodeParameter((String)login);
                loginParameters = loginParameters + "&Password=" + URIUtils.encodeParameter((String)password);
                loginParameters = loginParameters + "&UserPopulation=" + URIUtils.encodeParameter((String)userPopulation.getId());
                loginParameters = loginParameters + "&CredentialProviderIndex=" + i;
                loginParameters = loginParameters + "&context=" + URIUtils.encodeParameter((String)context);
                atLeastOneAvailablePopulation = true;
                resolver.resolveURI("cocoon:/authenticate?" + loginParameters);
                if (this._currentUserProvider.getUser() == null) continue;
                break;
            }
            catch (IOException e) {
                this.getLogger().error("Impossible to test logins on population '" + userPopulation.getId() + "' using credential provider at position '" + i + "'");
            }
        }
        return atLeastOneAvailablePopulation;
    }

    private boolean authenticate(String login, String password, Request request, SourceResolver resolver, Parameters parameters, UserPopulation userPopulation, List<CredentialProvider> providers) throws ParameterException {
        String siteName = parameters.getParameter("site");
        List<CallSite> populationContexts = List.of("/sites/" + siteName, "/sites-fo/" + siteName);
        for (String string : populationContexts) {
            this._tryConnect(login, password, request, resolver, string, userPopulation, providers);
        }
        return this._currentUserProvider.getUser() != null;
    }
}

