/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

MobileApp = {
    /**
     * Generates a token to use with the mobile app
     * @param {Object} config the configuration used to generate the token and display the link + qrcode
     * @param {String} config.siteUriPrefix site uri prefix, used for ajax call
     * @param {String} config.linkPrefix prefix used in the generated link (e.g. mobileapp:// )
     * @param {String} config.siteLink url to the site, used in the generated link
     * @param {String} config.siteName site name
     * @param {String} [config.elementForlinkId] element selector (e.g. #id) where the link will be appened. Can be null
     * @param {String} [config.linkText] The link text
     * @param {String} [config.elementToDisplayQRCodeId] element selector (e.g. #id) where the qr-code will be appened. Can be nul
     * @param {Function} [config.callbackWithToken] method that will be called after token generation, with 3 parameters. Boolean (success/error), String (token), string (link)
     */
    generateAuthenticationToken : function(config)
    {
        $j.ajax({ 
            url: config.siteUriPrefix + "/_plugins/mobileapp/generate-token.json", 
            type: 'POST',
            dataType: 'json',
            success: function(data) { 
                if (data && data.code == 200 && data.token)
                {
                    var link = config.linkPrefix + "?url=" + config.siteLink + "&name=" + config.siteName + "&token=" + data.token;
                    if (config.elementForlinkId)
                    {
                        var linkText = config.linkText || link;
                        var linkElement = $j('<a>').attr('href', link).text(linkText);
                        $j(config.elementForlinkId).empty();
                        $j(config.elementForlinkId).append(linkElement);
                    }
                    
                    if (config.elementToDisplayQRCodeId)
                    {
                        $j(config.elementToDisplayQRCodeId).empty();
                        $j(config.elementToDisplayQRCodeId).qrcode(link);
                    }
                    
                    // CallBack
                    if (config.callbackWithToken && typeof config.callbackWithToken == "function")
                    {
                        config.callbackWithToken(true, data.token, link);
                    }
                }
                else
                {
                    if (config.callbackWithToken && typeof config.callbackWithToken == "function")
                    {
                        config.callbackWithToken(false, null, null);
                    }
                }
            },
            error: function(xhr, status, error)
            {
                if (config.callbackWithToken && typeof config.callbackWithToken == "function")
                {
                    config.callbackWithToken(false, null, null);
                }
            }
        });
    }
}