/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;

public class GetThemeAction
extends ServiceableAction {
    protected static final String __PROJECT_ENABLED_CONF_ID = "plugin.mobileapp.project.enabled";
    protected static final String BASE_DIR = "context://WEB-INF/param/mobileapp/";
    public static final String THEME_JSON = "context://WEB-INF/param/mobileapp/theme.json";
    protected SiteManager _siteManager;
    protected SourceResolver _sourceResolver;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public String getHomeWebView(Site site) {
        String siteWebview = (String)site.getValue("mobileapp-webview");
        if (StringUtils.isNotBlank((CharSequence)siteWebview)) {
            return siteWebview;
        }
        String globalWebview = (String)Config.getInstance().getValue("plugin.mobileapp.home.webview");
        if (StringUtils.isNotBlank((CharSequence)globalWebview)) {
            return globalWebview;
        }
        return null;
    }

    public Map act(Redirector redirector, org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map<Object, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String siteName = parameters.getParameter("site");
        Site site = this._siteManager.getSite(siteName);
        if (site != null) {
            try {
                Map<String, Object> jsonMap = this.parseJson();
                result = this.transformMap(jsonMap, site);
                result.put("code", 200);
                result.put("name", site.getTitle());
                result.put("main_link", site.getUrl());
                boolean projectsEnabled = PluginsManager.getInstance().isPluginActive("workspaces") && (Boolean)Config.getInstance().getValue(__PROJECT_ENABLED_CONF_ID, false, (Object)false) != false;
                result.put("project_enabled", projectsEnabled);
                String homeWebView = this.getHomeWebView(site);
                if (homeWebView != null) {
                    result.put("home_webview", homeWebView);
                }
            }
            catch (JsonParseException e) {
                this.getLogger().error("Invalid JSON file for context://WEB-INF/param/mobileapp/theme.json", (Throwable)e);
                result = new HashMap();
                result.put("code", 500);
                result.put("message", "invalid-icons-json");
                HttpResponse response = (HttpResponse)ObjectModelHelper.getResponse((Map)objectModel);
                response.setStatus(500);
            }
        } else {
            result.put("code", 500);
            result.put("message", "site-not-found");
            HttpResponse response = (HttpResponse)ObjectModelHelper.getResponse((Map)objectModel);
            response.setStatus(500);
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Map<String, Object> parseJson() throws IOException {
        Map map;
        block9: {
            Source src = this._sourceResolver.resolveURI(THEME_JSON);
            File file = ((FileSource)src).getFile();
            if (!file.exists()) {
                throw new JsonParseException("The file context://WEB-INF/param/mobileapp/theme.json does not exist.");
            }
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                Map jsonMap;
                String body = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                map = jsonMap = this._jsonUtils.convertJsonToMap(body);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException("The file context://WEB-INF/param/mobileapp/theme.json must be a valid json containing a map with list of maps, at least : {\"icons\":[{\"src\":\"resources/img/logo96x96.png\"}]}.");
                }
            }
            is.close();
        }
        return map;
    }

    protected Map<String, Object> transformMap(Map<String, Object> jsonMap, Site site) throws MalformedURLException, IOException, JsonParseException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : jsonMap.keySet()) {
            Object object = jsonMap.get(key);
            Object transformedObject = this.transformObject(key, object, site);
            result.put(key, transformedObject);
        }
        return result;
    }

    protected List<Object> transformList(List<Object> jsonList, Site site) throws MalformedURLException, IOException, JsonParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : jsonList) {
            Object transformedObject = this.transformObject(null, object, site);
            result.add(transformedObject);
        }
        return result;
    }

    protected Object transformObject(String key, Object object, Site site) throws MalformedURLException, IOException, JsonParseException {
        Map<String, Object> result = object;
        if (object instanceof String) {
            String value = (String)((Object)object);
            if ("src".equalsIgnoreCase(key)) {
                result = this.getImageUrl(value, site);
            }
        } else if (object instanceof List) {
            List list = object;
            result = this.transformList(list, site);
        } else if (object instanceof Map) {
            Map map = (Map)((Object)object);
            result = this.transformMap(map, site);
        }
        return result;
    }

    protected String getImageUrl(String relativePath, Site site) {
        String url = site.getUrl() + "/skins/" + site.getSkinId() + "/" + relativePath;
        return url;
    }
}

