/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp;

/**
 * A holder for various constants for the mobileapp
 */
public final class PostConstants
{
    /** Size of the images */
    public static final int IMAGE_SIZE = 1024;

    /** Parameter containing the requested language */
    public static final String LANG = "language";

    /** Parameter containing the push token */
    public static final String NOTIF_TOKEN = "notification-token";

    /** Parameter containing the server url */
    public static final String URL = "url";

    /** Parameter containing the site name */
    public static final String SITE_NAME = "site";

    private PostConstants()
    {
        // Nothing
    }
}
