/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp;

import io.github.jav.exposerversdk.ExpoPushError;
import io.github.jav.exposerversdk.ExpoPushMessage;
import io.github.jav.exposerversdk.ExpoPushMessageCustomData;
import io.github.jav.exposerversdk.ExpoPushReceipt;
import io.github.jav.exposerversdk.ExpoPushTicket;
import io.github.jav.exposerversdk.PushClient;
import io.github.jav.exposerversdk.PushClientCustomData;
import io.github.jav.exposerversdk.PushClientException;
import io.github.jav.exposerversdk.PushNotificationErrorsException;
import io.github.jav.exposerversdk.PushNotificationException;
import io.github.jav.exposerversdk.enums.ReceiptError;
import io.github.jav.exposerversdk.enums.Status;
import io.github.jav.exposerversdk.enums.TicketError;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.schedule.DefaultRunnable;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.mobileapp.UserPreferencesHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.quartz.SchedulerException;

public class PushNotificationManager
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = PushNotificationManager.class.getName();
    private UserPreferencesHelper _userPreferencesHelper;
    private Scheduler _scheduler;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPreferencesHelper = (UserPreferencesHelper)((Object)manager.lookup(UserPreferencesHelper.ROLE));
        this._scheduler = (Scheduler)manager.lookup(Scheduler.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void pushNotifications(String title, String message, List<UserIdentity> users, Map<String, Object> data) throws PushClientException, SchedulerException {
        HashMap<UserIdentity, Set<String>> tokens = new HashMap<UserIdentity, Set<String>>();
        for (UserIdentity user : users) {
            tokens.put(user, this._userPreferencesHelper.getNotificationTokens(user));
        }
        this.pushNotifications(title, message, tokens, data);
    }

    public void pushNotifications(String title, String message, Map<UserIdentity, Set<String>> tokens, Map<String, Object> data) throws PushClientException, SchedulerException {
        List<String> validTokens = tokens.values().stream().flatMap(Collection::stream).filter(PushClientCustomData::isExponentPushToken).toList();
        if (validTokens.isEmpty()) {
            this.getLogger().debug("No valid token found, aborting push notification for message '{}'", (Object)title);
            return;
        }
        HashMap<String, UserIdentity> tokenToUserMap = new HashMap<String, UserIdentity>();
        for (Map.Entry<UserIdentity, Set<String>> entry : tokens.entrySet()) {
            for (String string : entry.getValue()) {
                tokenToUserMap.put(string, entry.getKey());
            }
        }
        PushClient client = new PushClient();
        List<TicketInfo> tickets = this._pushNotifications(title, message, tokenToUserMap, data, client);
        HashMap<String, String> recipientByTicket = new HashMap<String, String>();
        block6: for (TicketInfo ticketInfo : tickets) {
            ExpoPushTicket ticket = ticketInfo.ticket();
            String recipient = ticketInfo.token();
            switch (ticket.getStatus()) {
                case OK: {
                    recipientByTicket.put(ticket.getId(), recipient);
                    break;
                }
                case ERROR: {
                    if (ticket.getDetails().getError() == TicketError.DEVICENOTREGISTERED) {
                        String pushToken = (String)ticket.getDetails().getAdditionalProperties().get("expoPushToken");
                        if (!recipient.equals(pushToken)) continue block6;
                        UserIdentity user = (UserIdentity)tokenToUserMap.get(pushToken);
                        if (user != null) {
                            this.getLogger().info("Remove unregistered token {} for user {}", (Object)pushToken, (Object)user);
                            this._userPreferencesHelper.removeNotificationToken(pushToken, user);
                            break;
                        }
                        this.getLogger().warn("Received unregistered token {} but cannot find associated user", (Object)pushToken);
                        break;
                    }
                    this.getLogger().error("Received push error '{}': ", (Object)ticket.getDetails().getError(), (Object)ticket.getMessage());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown status for push ticket: " + String.valueOf(ticket.getStatus()));
                }
            }
        }
        this.getLogger().info("Got successfully sent push tickets: {}", recipientByTicket);
        Map<String, TokenInfo> map = recipientByTicket.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new TokenInfo((String)e.getValue(), UserIdentity.userIdentityToString((UserIdentity)((UserIdentity)tokenToUserMap.get(e.getValue()))))));
        ZonedDateTime dateTime = ZonedDateTime.now().plusMinutes(15L);
        DefaultRunnable runnable = new DefaultRunnable(((Object)((Object)this)).getClass().getName() + "$" + String.valueOf(UUID.randomUUID()), new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_PUSH_RUNNABLE_LABEL"), new I18nizableText("plugin.mobileapp", "PLUGINS_MOBILEAPP_PUSH_RUNNABLE_DESCRIPTION"), Runnable.FireProcess.CRON, dateTime.getSecond() + " " + dateTime.getMinute() + " " + dateTime.getHour() + " " + dateTime.getDayOfMonth() + " " + dateTime.getMonthValue() + " ? " + dateTime.getYear(), "org.ametys.plugins.mobileapp.push.schedule.PushReceipts", true, false, false, Runnable.MisfirePolicy.FIRE_ONCE, true, this._currentUserProvider.getUser(), Map.of("tickets", map));
        this._scheduler.scheduleJob((Runnable)runnable);
    }

    private List<TicketInfo> _pushNotifications(String title, String message, Map<String, UserIdentity> tokens, Map<String, Object> data, PushClient client) {
        this.getLogger().info("Pushing message '{}' with tokens {}", (Object)title, tokens);
        ExpoPushMessage expoPushMessage = new ExpoPushMessage();
        expoPushMessage.addAllTo(List.copyOf(tokens.keySet()));
        expoPushMessage.setTitle(title);
        expoPushMessage.setBody(message);
        expoPushMessage.setData(data);
        List chunks = client.chunkPushNotifications(List.of(expoPushMessage));
        ArrayList<TicketInfo> allTickets = new ArrayList<TicketInfo>();
        for (List chunk : chunks) {
            try {
                List tickets = (List)client.sendPushNotificationsAsync(chunk).join();
                List recipients = chunk.stream().map(ExpoPushMessageCustomData::getTo).flatMap(Collection::stream).toList();
                if (tickets.size() == recipients.size()) {
                    for (int i = 0; i < tickets.size(); ++i) {
                        allTickets.add(new TicketInfo((String)recipients.get(i), (ExpoPushTicket)tickets.get(i)));
                    }
                    continue;
                }
                this.getLogger().warn("Number of push tickets {} is different from number of recipients {}, something went wrong", (Object)tickets.size(), (Object)recipients.size());
            }
            catch (PushNotificationException e) {
                Exception exception = e.exception;
                if (exception instanceof PushNotificationErrorsException) {
                    PushNotificationErrorsException ex = (PushNotificationErrorsException)exception;
                    for (ExpoPushError error : ex.errors) {
                        if ("PUSH_TOO_MANY_EXPERIENCE_IDS".equals(error.getCode())) {
                            StringBuilder errorMessage = new StringBuilder("Push message " + title + " failed because tokens are associated with more than one expo project. Message will be split and sent again but you may want to remove wrong tokens:");
                            ArrayList tokensByProject = new ArrayList();
                            Map details = (Map)error.getAdditionalProperties().get("details");
                            for (String string : details.keySet()) {
                                errorMessage.append("\n\nFollowing tokens are associated with project ").append(string).append(':');
                                List expoTokens = (List)details.get(string);
                                HashMap<String, UserIdentity> tokenForProject = new HashMap<String, UserIdentity>();
                                tokensByProject.add(tokenForProject);
                                for (String expoToken : expoTokens) {
                                    UserIdentity userIdentity = tokens.get(expoToken);
                                    errorMessage.append('\n').append(expoToken).append(" for user ").append(UserIdentity.userIdentityToString((UserIdentity)userIdentity));
                                    tokenForProject.put(expoToken, userIdentity);
                                }
                            }
                            this.getLogger().error(errorMessage.toString());
                            for (Map map : tokensByProject) {
                                allTickets.addAll(this._pushNotifications(title, message, map, data, client));
                            }
                            continue;
                        }
                        this.getLogger().error("Push notification {} returned an error with code '{}': {}", new Object[]{title, error.getCode(), error.getMessage(), ex});
                    }
                    continue;
                }
                this.getLogger().error("Exception while sending push notification {}", (Object)title, (Object)e);
            }
        }
        return allTickets;
    }

    public void checkTickets(Map<String, TokenInfo> tickets) throws Exception {
        if (tickets.isEmpty()) {
            this.getLogger().debug("No ticket to check");
            return;
        }
        this.getLogger().info("Checking tickets {}", tickets);
        PushClient client = new PushClient();
        List chunks = client.chunkPushNotificationReceiptIds(List.copyOf(tickets.keySet()));
        for (List chunk : chunks) {
            try {
                List receipts = (List)client.getPushNotificationReceiptsAsync(chunk).join();
                for (ExpoPushReceipt receipt : receipts) {
                    TokenInfo tokenInfo;
                    if (receipt.getStatus() != Status.ERROR || receipt.getDetails().getError() != ReceiptError.DEVICENOTREGISTERED || (tokenInfo = tickets.get(receipt.getId())) == null) continue;
                    String user = tokenInfo.user();
                    String token = tokenInfo.token();
                    this.getLogger().warn("Device not registered for token {} associated with user {}, it will be removed", (Object)token, (Object)user);
                    UserIdentity userIdentity = UserIdentity.stringToUserIdentity((String)user);
                    this._userPreferencesHelper.removeNotificationToken(token, userIdentity);
                }
            }
            catch (PushNotificationException e) {
                this.getLogger().error("Exception while getting push receipts", (Throwable)e);
            }
        }
    }

    private record TicketInfo(String token, ExpoPushTicket ticket) {
    }

    public record TokenInfo(String token, String user) implements Serializable
    {
    }
}

