/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public abstract class AbstractGetTokenAction
extends ServiceableAction
implements ThreadSafe {
    protected AuthenticationTokenManager _authenticationTokenManager;
    protected UserPopulationDAO _userPopulationDAO;
    protected PopulationContextHelper _populationContextHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._authenticationTokenManager = (AuthenticationTokenManager)smanager.lookup(AuthenticationTokenManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)smanager.lookup(PopulationContextHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String body = null;
        HttpServletRequest postReq = (HttpServletRequest)objectModel.get("httprequest");
        try (ServletInputStream postBody = postReq.getInputStream();){
            body = new String(postBody.readAllBytes(), StandardCharsets.UTF_8);
        }
        String siteName = parameters.getParameter("site");
        List<CallSite> populationContexts = List.of("/sites/" + siteName, "/sites-fo/" + siteName);
        Map jsonParams = this._jsonUtils.convertJsonToMap(body);
        String population = (String)this.getParameter("population", jsonParams, request);
        UserIdentity user = null;
        UserPopulation userPopulation = population != null ? this._userPopulationDAO.getUserPopulation(population) : null;
        user = userPopulation != null ? this.authenticate(jsonParams, request, parameters, populationContexts, userPopulation) : this.authenticate(jsonParams, request, parameters, populationContexts);
        if (user == null) {
            result.put("code", 403);
            throw new AccessDeniedException();
        }
        String generateToken = this._authenticationTokenManager.generateToken(user, 0L, "mobileapp", "Token for the mobile app");
        result.put("code", 200);
        result.put("token", generateToken);
        this._currentUserProvider.logout(null);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Object getParameter(String name, Map<String, Object> jsonParams, Request request) {
        if (jsonParams.containsKey(name)) {
            return jsonParams.get(name);
        }
        if (request.getParameter(name) != null) {
            return request.getParameter(name);
        }
        return request.getAttribute(name);
    }

    private UserIdentity authenticate(Map<String, Object> params, Request request, Parameters parameters, List<String> populationContexts) throws ParameterException {
        String siteName = parameters.getParameter("site");
        for (String context : populationContexts) {
            List<UserPopulation> populations = this._populationContextHelper.getUserPopulationsOnContexts(List.of(context), false, false).stream().map(arg_0 -> ((UserPopulationDAO)this._userPopulationDAO).getUserPopulation(arg_0)).toList();
            for (UserPopulation population : populations) {
                UserIdentity user = this._tryConnect(params, request, context, population);
                if (user == null) continue;
                return user;
            }
        }
        this.getLogger().error("Unable to log in from the mobile application to the '" + siteName + "' site. At least one population should be configured with credential provider compatible with the mobile app.");
        return null;
    }

    private UserIdentity authenticate(Map<String, Object> params, Request request, Parameters parameters, List<String> populationContexts, UserPopulation userPopulation) throws ParameterException {
        String siteName = parameters.getParameter("site");
        Set contextsForUserPopulation = this._populationContextHelper.getContextsForUserPopulation(userPopulation.getId());
        for (String context : populationContexts) {
            UserIdentity user;
            if (!contextsForUserPopulation.contains(context) || (user = this._tryConnect(params, request, context, userPopulation)) == null) continue;
            return user;
        }
        this.getLogger().error("Unable to log in from the mobile application to the '" + siteName + "' site, with population '" + userPopulation.getId() + "'.");
        return null;
    }

    private UserIdentity _tryConnect(Map<String, Object> params, Request request, String context, UserPopulation userPopulation) {
        List credentialProviders = userPopulation.getCredentialProviders();
        for (int i = 0; i < credentialProviders.size(); ++i) {
            CredentialProvider credentialProvider = (CredentialProvider)credentialProviders.get(i);
            UserIdentity user = this.tryConnect(params, request, context, userPopulation, credentialProvider, i);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    protected abstract UserIdentity tryConnect(Map<String, Object> var1, Request var2, String var3, UserPopulation var4, CredentialProvider var5, int var6);
}

