/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.core.right.RightManager;
import org.ametys.plugins.mobileapp.QueriesHelper;
import org.ametys.plugins.mobileapp.action.AbstractLoggedAction;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

public class GetFeedsContentsAction
extends AbstractLoggedAction {
    protected QueriesHelper _queryHelper;
    protected SiteManager _siteManager;
    private RightManager _rightManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._queryHelper = (QueriesHelper)((Object)smanager.lookup(QueriesHelper.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String siteName = (String)this.getParameter("site", jsonParams, request);
        Site site = this._siteManager.getSite(siteName);
        List<Query> queries = this._queryHelper.getQueries(site);
        ArrayList results = new ArrayList();
        for (Query query : queries) {
            List<ContentSearcherFactory.ContentSearchSort> sort;
            AmetysObjectIterable<Content> searchResults;
            if (!this._rightManager.hasReadAccess(this._currentUserProvider.getUser(), (Object)query) || (searchResults = this._queryHelper.executeQuery(query, sort = this._queryHelper.getSortProperty(query, queries.size() > 1), true)) == null) continue;
            ContentSearcherFactory.ContentSearchSort firstSort = sort.get(0);
            searchResults.stream().forEach(content -> results.add(new QuerySearchresult(this, query, firstSort, (Content)content)));
        }
        Comparator<QuerySearchresult> comparator = new Comparator<QuerySearchresult>(){

            @Override
            public int compare(QuerySearchresult o1, QuerySearchresult o2) {
                Object o1Value = this.getDate(o1);
                Object o2Value = this.getDate(o2);
                return GetFeedsContentsAction.this.compareDates(o1Value, o2Value);
            }

            private Object getDate(QuerySearchresult queryResult) {
                String field = queryResult.getSort().sortField();
                Content content = queryResult.getContent();
                Object value = content.hasValue(field) ? content.getValue(field, true, null) : content.getLastValidationDate();
                return value;
            }
        };
        List jsonResults = queries.size() > 1 ? results.stream().sorted(comparator).map(searchResult -> this.contentToJson((QuerySearchresult)searchResult)).collect(Collectors.toList()) : results.stream().map(searchResult -> this.contentToJson((QuerySearchresult)searchResult)).collect(Collectors.toList());
        result.put("items", jsonResults);
        return result;
    }

    protected Map<String, String> contentToJson(QuerySearchresult searchResult) {
        Content content = searchResult.getContent();
        Map<String, String> result = this._queryHelper.getDataForContent(content);
        result.put("feed_id", searchResult.getQueryId());
        result.put("category_name", searchResult.getQueryName());
        String sortField = searchResult.getSort().sortField();
        String isoDate = this._queryHelper.getContentFormattedDate(content, sortField);
        result.put("date", isoDate);
        return result;
    }

    protected int compareDates(Object o1, Object o2) throws ClassCastException {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return ((Date)o1).compareTo((Date)o2);
        }
        if (o1 instanceof LocalDate && o2 instanceof LocalDate) {
            return ((LocalDate)o1).compareTo((LocalDate)o2);
        }
        if (o1 instanceof ZonedDateTime && o2 instanceof ZonedDateTime) {
            return ((ZonedDateTime)o1).compareTo((ZonedDateTime)o2);
        }
        Instant i1 = this._queryHelper.toInstant(o1, o2);
        Instant i2 = this._queryHelper.toInstant(o2, o1);
        if (i1 != null && i2 != null) {
            return i1.compareTo(i2);
        }
        throw new ClassCastException();
    }

    protected class QuerySearchresult {
        private Query _query;
        private ContentSearcherFactory.ContentSearchSort _sort;
        private Content _content;

        public QuerySearchresult(GetFeedsContentsAction this$0, Query query, ContentSearcherFactory.ContentSearchSort sort, Content content) {
            this._query = query;
            this._sort = sort;
            this._content = content;
        }

        public String getQueryId() {
            return this._query.getId();
        }

        public String getQueryName() {
            return this._query.getTitle();
        }

        public ContentSearcherFactory.ContentSearchSort getSort() {
            return this._sort;
        }

        public Content getContent() {
            return this._content;
        }
    }
}

