/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.text.ParseException;
import java.util.Map;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.plugins.extrausermgt.authentication.oidc.OIDCBasedCredentialProvider;
import org.ametys.plugins.mobileapp.action.AbstractGetTokenAction;
import org.apache.cocoon.environment.Request;

public class GetTokenFromOIDCAction
extends AbstractGetTokenAction {
    @Override
    protected UserIdentity tryConnect(Map<String, Object> params, Request request, String context, UserPopulation userPopulation, CredentialProvider credentialProvider, int credentialProviderIndex) {
        if (credentialProvider instanceof OIDCBasedCredentialProvider) {
            OIDCBasedCredentialProvider oidcCredentialProvider = (OIDCBasedCredentialProvider)credentialProvider;
            try {
                String idToken = (String)this.getParameter("idToken", params, request);
                JWT token = JWTParser.parse((String)idToken);
                IDTokenValidator validator = new IDTokenValidator(new Issuer(oidcCredentialProvider.getIssuer()), new ClientID(oidcCredentialProvider.getClientId()), JWSAlgorithm.RS256, oidcCredentialProvider.getJwkSetURL());
                IDTokenClaimsSet claims = validator.validate(token, null);
                String login = claims.getStringClaim("preferred_username");
                for (UserDirectory userDirectory : userPopulation.getUserDirectories()) {
                    if (userDirectory.getStoredUser(login) == null) continue;
                    return new UserIdentity(login, userPopulation.getId());
                }
            }
            catch (JOSEException | BadJOSEException | ParseException e) {
                this.getLogger().error("Impossible to validate id token  on population '" + userPopulation.getId() + "' using credential provider at position '" + credentialProviderIndex + "'", e);
            }
        }
        return null;
    }
}

