/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.mobileapp.UserPreferencesHelper;
import org.ametys.plugins.mobileapp.action.AbstractLoggedAction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class LogoutAction
extends AbstractLoggedAction {
    protected UserPreferencesHelper _userPreferencesHelper;
    protected AuthenticationTokenManager _authenticationTokenManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userPreferencesHelper = (UserPreferencesHelper)((Object)smanager.lookup(UserPreferencesHelper.ROLE));
        this._authenticationTokenManager = (AuthenticationTokenManager)smanager.lookup(AuthenticationTokenManager.ROLE);
    }

    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String token = request.getHeader("X-Ametys-Token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = (String)this.getParameter("token", jsonParams, request);
        }
        this._authenticationTokenManager.deleteTokenByValue(token, "mobileapp");
        String notificationToken = (String)this.getParameter("notification-token", jsonParams, request);
        this._userPreferencesHelper.removeNotificationToken(notificationToken);
        try {
            this._currentUserProvider.logout(null);
            result.put("code", 200);
        }
        catch (ProcessingException e) {
            this.getLogger().warn("Exception while loggin out user '" + UserIdentity.userIdentityToString((UserIdentity)this._currentUserProvider.getUser()) + "'", (Throwable)e);
            result.put("code", 500);
        }
        return result;
    }
}

