/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.mobileapp.UserPreferencesHelper;
import org.ametys.plugins.mobileapp.action.AbstractLoggedAction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class SetNotificationsPrefsAction
extends AbstractLoggedAction {
    protected static final String _NOTIF_ENABLED = "enabled";
    protected static final String _NOTIF_ALL_FEEDS = "allFeeds";
    protected static final String _NOTIF_FEEDS = "feeds";
    protected static final String _NOTIF_WORKSPACES = "workspaces";
    protected static final String _NOTIF_ALL_PROJECTS = "allProjects";
    protected static final String _NOTIF_PROJECTS = "projects";
    protected static final String _NOTIF_ALL_TYPES = "allTypes";
    protected static final String _NOTIF_TYPES = "types";
    protected UserPreferencesHelper _userPreferencesHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userPreferencesHelper = (UserPreferencesHelper)((Object)smanager.lookup(UserPreferencesHelper.ROLE));
    }

    @Override
    protected Map<String, Object> doLoggedInAction(Request request, Map<String, Object> jsonParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String lang = (String)this.getParameter("language", jsonParams, request);
        String pushToken = (String)this.getParameter("notification-token", jsonParams, request);
        List feeds = (List)this.getParameter(_NOTIF_FEEDS, jsonParams, request);
        Map workspaces = (Map)this.getParameter(_NOTIF_WORKSPACES, jsonParams, request);
        List projects = workspaces != null ? (List)workspaces.get(_NOTIF_PROJECTS) : null;
        List types = workspaces != null ? (List)workspaces.get(_NOTIF_TYPES) : null;
        boolean defaultAllFeedsValue = feeds == null;
        boolean defaultAllProjectsValue = projects == null;
        boolean defaultAllTypesValue = types == null;
        boolean defaultDisabled = feeds != null && feeds.isEmpty() && projects != null && projects.isEmpty() && types != null && types.isEmpty();
        boolean enabled = this._getValueOrDefault((Boolean)this.getParameter(_NOTIF_ENABLED, jsonParams, request), !defaultDisabled);
        boolean allFeeds = this._getValueOrDefault((Boolean)this.getParameter(_NOTIF_ALL_FEEDS, jsonParams, request), defaultAllFeedsValue);
        boolean allProjects = this._getValueOrDefault(workspaces != null ? (Boolean)workspaces.get(_NOTIF_ALL_PROJECTS) : null, defaultAllProjectsValue);
        boolean allTypes = this._getValueOrDefault(workspaces != null ? (Boolean)workspaces.get(_NOTIF_ALL_TYPES) : null, defaultAllTypesValue);
        feeds = feeds != null ? feeds.stream().filter(StringUtils::isNotBlank).toList() : null;
        types = types != null ? types.stream().filter(StringUtils::isNotBlank).toList() : null;
        projects = projects != null ? projects.stream().filter(StringUtils::isNotBlank).toList() : null;
        this._userPreferencesHelper.setNotificationSettings(pushToken, enabled, allFeeds, feeds, allProjects, projects, allTypes, types, lang);
        return result;
    }

    private boolean _getValueOrDefault(Boolean value, boolean defaultValue) {
        return value != null ? value : defaultValue;
    }
}

