<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:exsl="http://exslt.org/common"
    xmlns:math="java.lang.Math"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    xmlns:encoder="java.net.URLEncoder"
    xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
    extension-element-prefixes="resolver exsl math escaper ametys encoder event">

    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service:mobileapp://stylesheets/mobilelinkhelper.xsl"/>

    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>

    <xsl:variable name="title" select="string(ametys:serviceParameter('title')/text())"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">mobilelink</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/>
    <xsl:variable name="common-service-name">service-mobilelink</xsl:variable>

    <xsl:variable name="callback-function">function(success) {
        if (success)
        {
            $j('#access-<xsl:value-of select="$uniqueId"/>').fadeIn();
        }
    }</xsl:variable>
    
    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$title"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="import-head-js"/>
    </xsl:template>


    <!-- +
         | BODY
         + -->
    <!-- Defined in the service because of the id  -->
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>

            <xsl:call-template name="common-service-body-nonempty-content-content"/>
        </div>
    </xsl:template>

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$title"/>
        </xsl:call-template>
    </xsl:template>

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="mobilelink-download-links"/>

        <xsl:call-template name="mobilelink-connection-links"/>
    </xsl:template>

    <!-- Template used to display download links -->
    <xsl:template name="mobilelink-download-links">

        <div class="{$common-service-css-class-name}__store-links">
            <xsl:call-template name="display-gplay-store-link"/>
            <xsl:call-template name="display-apple-store-link"/>
        </div>
    </xsl:template>
    
    <!-- Template used to display link and QR code -->
    <xsl:template name="mobilelink-connection-links">
        
        <xsl:call-template name="mobilelink-connection-generate-btn"/>
        
        <xsl:call-template name="mobilelink-connection-access"/>
        
    </xsl:template>
    
    <xsl:template name="mobilelink-connection-generate-btn">
        <xsl:variable name="onclick">
            <xsl:call-template name="generate-js-method-call">
                <xsl:with-param name="element-id-to-visual-link">#access-link-<xsl:value-of select="$uniqueId" /></xsl:with-param>
                <xsl:with-param name="element-id-to-insert-qrcode">#access-qr-<xsl:value-of select="$uniqueId" /></xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
            
        <div id="generate-link-{$uniqueId}" class="{$common-service-css-class-name}__generate-link">
            <a href="javascript:void(0)" onclick="{$onclick}">
                <i18n:text i18n:key="SERVICE_MOBILE_LINK_GENERATE_ACCESS"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="mobilelink-connection-access">
        <div id="access-{$uniqueId}" class="{$common-service-css-class-name}__access" style="display: none">
        
            <xsl:call-template name="mobilelink-connection-access-link"/>
            
            <xsl:call-template name="mobilelink-connection-access-separator"/>
            
            <xsl:call-template name="mobilelink-connection-access-qrcode"/>
        </div>
    </xsl:template>
    
    <xsl:template name="mobilelink-connection-access-link">
        <p class="{$common-service-css-class-name}__access-link-text">
            <i18n:text i18n:key="SERVICE_MOBILE_LINK_ACCESS_LINK"/>
        </p>
        
        <div class="{$common-service-css-class-name}__access-link" id="access-link-{$uniqueId}"></div>
    </xsl:template>
    
    <xsl:template name="mobilelink-connection-access-qrcode">
        <p class="{$common-service-css-class-name}__access-qrcode-text">
            <i18n:text i18n:key="SERVICE_MOBILE_LINK_ACCESS_QRCODE"/>
        </p>
        
        <div id="access-qr-{$uniqueId}" class="{$common-service-css-class-name}__access-qrcode"></div>
    </xsl:template>
    
    <xsl:template name="mobilelink-connection-access-separator">
        <div class="{$common-service-css-class-name}__access-separator"><i18n:text i18n:key="SERVICE_MOBILE_LINK_ACCESS_SEPARATOR"/></div>
    </xsl:template>
    
</xsl:stylesheet>