<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    extension-element-prefixes="ametys">
    
    
    <xsl:variable name="android-store-link" select="string(ametys:serviceParameter('android-store-link')/text())"/>
    <xsl:variable name="ios-store-link" select="string(ametys:serviceParameter('ios-store-link')/text())"/>
    <xsl:variable name="linkPrefix" select="string(ametys:serviceParameter('linkPrefix')/text())"/>

    <xsl:variable name="callback-function">null</xsl:variable>
        
    <!-- Template to import the needed JavaScript files -->
    <xsl:template name="import-head-js">
        <script src="{$uri-prefix}/plugins/mobileapp/resources/js/qrcode.js" type="text/javascript"/>
        <script src="{$uri-prefix}/plugins/mobileapp/resources/js/jquery.qrcode.js" type="text/javascript"/>
        <script src="{$uri-prefix}/plugins/mobileapp/resources/js/mobileLink.js" type="text/javascript"/>
    </xsl:template>
    
    <!-- Template used to generate the javascript method call -->
    <xsl:template name="generate-js-method-call">
        <xsl:param name="element-id-to-visual-link"></xsl:param>
        <xsl:param name="element-id-to-insert-qrcode"></xsl:param>
        <xsl:param name="link-text"/>
        <xsl:param name="callback-method" select="$callback-function"/>
        MobileApp.generateAuthenticationToken({
            'siteUriPrefix' : '<xsl:value-of select="$site-uri-prefix" />', 
	        'linkPrefix' : '<xsl:value-of select="$linkPrefix" />', 
	        'siteLink' : '<xsl:value-of select="$absolute-site-uri-prefix" />', 
	        'siteName' : '<xsl:value-of select="$site" />', 
	        'elementForlinkId' : '<xsl:value-of select="$element-id-to-visual-link" />', 
            'linkText': "<xsl:value-of select="$link-text"/>",
	        'elementToDisplayQRCodeId' : '<xsl:value-of select="$element-id-to-insert-qrcode" />', 
	        'callbackWithToken' : <xsl:value-of select="$callback-method" />
	        }); return false;
    </xsl:template>
    
    <!-- Template used to display download links on Android -->
    <xsl:template name="display-gplay-store-link">
        <xsl:param name="common-service-css-class-name">mobilelink</xsl:param>
        <xsl:param name="height">60px</xsl:param>
        
        <xsl:variable name="imagesPath" select="ametys:pluginResourceURL('mobileapp', 'img/')"/>
        <a target="_blank" href="{$android-store-link}" rel="noreferrer noopener" class="{$common-service-css-class-name}-market-link {$common-service-css-class-name}-gplay-market-link">
            <img src="{$imagesPath}googleplay.png" alt="Android app" style="height:{$height}" />
        </a>
    </xsl:template> 
    
    <!-- Template used to display download links on IOS -->
    <xsl:template name="display-apple-store-link">
        <xsl:param name="common-service-css-class-name">mobilelink</xsl:param>
        <xsl:param name="height">60px</xsl:param>
        
        <xsl:variable name="imagesPath" select="ametys:pluginResourceURL('mobileapp', 'img/')"/>
            <a target="_blank" href="{$ios-store-link}" rel="noreferrer noopener" class="{$common-service-css-class-name}-market-link {$common-service-css-class-name}-gplay-market-link">
                <img src="{$imagesPath}appstore.svg" alt="iOS app" style="height:{$height}" />
            </a>
    </xsl:template> 
    
</xsl:stylesheet>