/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.mobileapp.action;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

import org.ametys.plugins.mobileapp.PostConstants;
import org.ametys.plugins.mobileapp.SiteHelper;

/**
 * Returns the site from an URL
 */
public class GetSiteAction extends AbstractPostAction
{
    private SiteHelper _siteHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _siteHelper = (SiteHelper) smanager.lookup(SiteHelper.ROLE);
    }

    @Override
    protected Map<String, Object> doAction(Request request, Map<String, Object> jsonParams)
    {
        Map<String, Object> result = new HashMap<>();

        String url = (String) getParameter(PostConstants.URL, jsonParams, request);
        if (url.endsWith("/"))
        {
            url = url.substring(0, url.length() - 1);
        }
        String siteName = _siteHelper.getSiteByUrl(url);

        if (siteName == null)
        {
            result.put("code", 500);
            throw new RuntimeException("Unable to retrieve site with url: " + url);
        }

        result.put("site_name", siteName);

        result.put("code", 200);

        return result;
    }
}
