/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter;

import java.util.Arrays;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.site.CopyUpdater;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class NewsletterCopyUpdater
extends AbstractLogEnabled
implements CopyUpdater,
ThreadSafe,
Serviceable {
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public void updateContent(Site initialSite, Site createdSite, Content initialContent, Content createdContent) {
        try {
            String category;
            if (Arrays.asList(createdContent.getTypes()).contains("org.ametys.plugins.newsletter.Content.newsletter") && (category = (String)createdContent.getInternalDataHolder().getValue("category")).startsWith("category_page://")) {
                String pageId = category.substring("category_".length());
                Page initialPage = (Page)this._resolver.resolveById(pageId);
                try {
                    Page copiedPage = (Page)createdSite.getSitemap(initialPage.getSitemapName()).getChild(initialPage.getPathInSitemap());
                    createdContent.getInternalDataHolder().setValue("category", (Object)("category_" + copiedPage.getId()));
                }
                catch (UnknownAmetysObjectException e) {
                    createdContent.getInternalDataHolder().removeValue("category");
                }
            }
        }
        catch (AmetysRepositoryException e) {
            this.getLogger().warn("[Site copy] Unable to update newsletter category for content '" + createdContent.getId() + "'", (Throwable)e);
        }
    }

    public void updatePage(Site initialSite, Site createdSite, Page page) {
    }

    public void updateSite(Site initialSite, Site createdSite) {
    }
}

