/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.actions;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetNewsletterTemplateAction
extends ServiceableAction {
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean textMode = parameters.getParameterAsBoolean("text-mode", false);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        WebContent content = (WebContent)request.getAttribute(Content.class.getName());
        String categoryID = (String)content.getInternalDataHolder().getValue("category");
        Set providerIDs = this._categoryProviderEP.getExtensionsIds();
        for (String providerID : providerIDs) {
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(providerID);
            if (!provider.hasCategory(categoryID)) continue;
            Category category = provider.getCategory(categoryID);
            String templateId = category.getTemplate();
            String templateUrl = "skin://newsletter/" + templateId + "/stylesheets/" + (textMode ? "template-text.xsl" : "template.xsl");
            result.put("template", templateUrl);
            String categoryTitle = this._i18nUtils.translate((I18nizable)category.getTitle(), category.getLang());
            result.put("categoryId", categoryID);
            result.put("categoryTitle", categoryTitle);
        }
        long num = (Long)content.getValue("newsletter-number", false, (Object)-1L);
        LocalDate date = (LocalDate)content.getValue("newsletter-date");
        result.put("title", content.getTitle());
        if (num > -1L) {
            result.put("number", Long.toString(num));
        }
        if (date != null) {
            result.put("date", DateTimeFormatter.ISO_LOCAL_DATE.format(date.atStartOfDay(ZoneId.systemDefault())));
        }
        result.put("contentLanguage", content.getLanguage());
        Site site = content.getSite();
        if (site != null) {
            request.setAttribute("site", (Object)site.getName());
            Sitemap sitemap = site.getSitemap(content.getLanguage());
            if (sitemap != null) {
                request.setAttribute(WebConstants.REQUEST_ATTR_SITEMAP, (Object)sitemap);
            }
        }
        return result;
    }
}

