/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.newsletter.NewsletterDAO;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryDAO;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetNewslettersAction
extends ServiceableAction {
    private static final String __PROVIDER_TYPE = "newsletter-category-provider";
    private static final String __CATEGORY_TYPE = "newsletter-category";
    private static final String __NEWSLETTER_TYPE = "newsletter";
    private static final String __MODE_WRITE = "write";
    private static final String __MODE_READ = "read";
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private NewsletterDAO _newsletterDAO;
    private CategoryDAO _categoryDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)serviceManager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._newsletterDAO = (NewsletterDAO)((Object)serviceManager.lookup(NewsletterDAO.ROLE));
        this._categoryDAO = (CategoryDAO)((Object)serviceManager.lookup(CategoryDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String categoryID = (String)jsParameters.get("node");
        String siteName = (String)jsParameters.get("sitename");
        String lang = (String)jsParameters.get("lang");
        boolean categoriesOnly = (Boolean)jsParameters.get("categoriesOnly");
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        if (StringUtils.isEmpty((CharSequence)categoryID) || "root".equals(categoryID)) {
            ids = this._categoryProviderEP.getExtensionsIds();
            for (String id : ids) {
                CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
                nodes.add(this.providerToJSON(provider, siteName, lang));
            }
        } else if (categoryID.startsWith("provider_")) {
            String id = categoryID.substring("provider_".length());
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
            List<Category> childCategories = provider.getCategories(siteName, lang);
            for (Category child : childCategories) {
                nodes.add(this.categoryToJSON(child, provider, categoriesOnly));
            }
        } else {
            ids = this._categoryProviderEP.getExtensionsIds();
            for (String id : ids) {
                CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
                if (!provider.hasCategory(categoryID)) continue;
                Category category = provider.getCategory(categoryID);
                List<Category> childCategories = provider.getCategories(category.getId());
                for (Category child : childCategories) {
                    nodes.add(this.categoryToJSON(child, provider, categoriesOnly));
                }
                if (categoriesOnly) continue;
                AmetysObjectIterable<Content> childNewsletters = provider.getNewsletters(category.getId(), siteName, lang);
                for (Content content : childNewsletters) {
                    nodes.add(this.newsletterToJSON(content, provider));
                }
            }
        }
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        result.put("children", nodes);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Map<String, Object> providerToJSON(CategoryProvider categoryProvider, String siteName, String lang) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", "provider_" + categoryProvider.getId());
        infos.put("type", __PROVIDER_TYPE);
        infos.put("hasChildren", !categoryProvider.getCategories(siteName, lang).isEmpty());
        infos.put("mode", categoryProvider.isWritable() ? __MODE_WRITE : __MODE_READ);
        infos.put("title", categoryProvider.getLabel());
        infos.put("description", categoryProvider.getDescription());
        return infos;
    }

    protected Map<String, Object> categoryToJSON(Category category, CategoryProvider categoryProvider, boolean categoriesOnly) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        String id = category.getId();
        String siteName = category.getSiteName();
        boolean hasChildren = categoryProvider.hasChildren(id) || !categoriesOnly && categoryProvider.hasNewsletters(id, siteName, category.getLang());
        infos.putAll(this._categoryDAO.getCategory(id));
        infos.put("type", __CATEGORY_TYPE);
        infos.put("hasChildren", hasChildren);
        return infos;
    }

    protected Map<String, Object> newsletterToJSON(Content newsletter, CategoryProvider categoryProvider) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.putAll(this._newsletterDAO.getNewsletterProperties(newsletter));
        infos.put("type", __NEWSLETTER_TYPE);
        infos.put("hasChildren", false);
        return infos;
    }
}

