/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetSubscribersAction
extends ServiceableAction {
    private SubscribersDAO _subscribersDao;
    private JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._subscribersDao = (SubscribersDAO)((Object)serviceManager.lookup(SubscribersDAO.ROLE));
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        List<Subscriber> subscribers;
        Map jsParameters = (Map)objectModel.get("parent-context");
        String categoryId = (String)jsParameters.get("categoryID");
        String siteName = (String)jsParameters.get("siteName");
        int begin = jsParameters.getOrDefault("start", 0);
        int offset = jsParameters.getOrDefault("limit", Integer.MAX_VALUE);
        List<Map<String, Object>> sorts = this._getSorts(jsParameters.get("sort"));
        ArrayList<Map<String, Object>> subscribersResult = new ArrayList<Map<String, Object>>();
        int total = 0;
        if (siteName != null && categoryId != null) {
            subscribers = this._subscribersDao.getSubscribers(siteName, categoryId, sorts, begin, offset);
            total = this._subscribersDao.getSubscribersCount(siteName, categoryId);
        } else {
            subscribers = this._subscribersDao.getSubscribers(sorts);
            total = subscribers.size();
        }
        for (Subscriber subscriber : subscribers) {
            subscribersResult.add(this.subscriberToJSON(subscriber));
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("subscribers", subscribersResult);
        result.put("total", Integer.valueOf(total));
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Map<String, Object> subscriberToJSON(Subscriber subscriber) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("email", subscriber.getEmail());
        infos.put("siteName", subscriber.getSiteName());
        infos.put("category", subscriber.getCategoryId());
        infos.put("subscribedAt", DateUtils.dateToString((Date)subscriber.getSubscribedAt()));
        return infos;
    }

    private List<Map<String, Object>> _getSorts(Object sortValues) {
        if (sortValues != null) {
            return this._jsonUtils.convertJsonToList(sortValues.toString());
        }
        return null;
    }
}

