/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.analytics;

import org.ametys.web.analytics.WebAnalyticsHelper;
import org.ametys.web.analytics.WebAnalyticsProvider;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class WebAnalyticsXsltHelper
implements Serviceable {
    private static WebAnalyticsHelper _webAnalyticsHelper;
    private static SiteManager _siteManager;

    public void service(ServiceManager manager) throws ServiceException {
        _webAnalyticsHelper = (WebAnalyticsHelper)manager.lookup(WebAnalyticsHelper.ROLE);
        _siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public static String eventImageUri(String siteName, String category, String action, String label) {
        return WebAnalyticsXsltHelper.eventImageUri(siteName, category, action, label, 0);
    }

    public static String eventImageUri(String siteName, String category, String action, String label, int value) {
        Site site = _siteManager.getSite(siteName);
        if (WebAnalyticsXsltHelper._isNewsletterTrackingEnabled(site)) {
            WebAnalyticsProvider provider = _webAnalyticsHelper.getSelectedProvider(site);
            return provider.getEventImageUri(site, category, action, label, value, true);
        }
        return null;
    }

    public static String eventLinkCampaignParams(String siteName, String campaign, String medium, String source) {
        Site site = _siteManager.getSite(siteName);
        if (WebAnalyticsXsltHelper._isNewsletterTrackingEnabled(site)) {
            WebAnalyticsProvider provider = _webAnalyticsHelper.getSelectedProvider(site);
            return provider.getEventLinkCampaignParams(site, campaign, medium, source);
        }
        return null;
    }

    private static boolean _isNewsletterTrackingEnabled(Site site) {
        return (Boolean)site.getValue("newsletter-enable-tracking", false, (Object)true);
    }
}

