/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.newsletter.auto.AutomaticNewsletterExtensionPoint;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class AutomaticNewsletterClientSideElement
extends StaticClientSideElement {
    protected AutomaticNewsletterExtensionPoint _autoNewsletterEP;
    protected CategoryProviderExtensionPoint _categoryProviderEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._autoNewsletterEP = (AutomaticNewsletterExtensionPoint)((Object)serviceManager.lookup(AutomaticNewsletterExtensionPoint.ROLE));
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)serviceManager.lookup(CategoryProviderExtensionPoint.ROLE));
    }

    @Callable(rights={"Plugins_Newsletter_Right_SetAutomatic"})
    public Map<String, Object> getStatus(List<String> categoryIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList categoryWithAutoNewsletters = new ArrayList();
        for (String categoryId : categoryIds) {
            Category category = this._categoryProviderEP.getCategory(categoryId);
            CategoryProvider provider = this._categoryProviderEP.getCategoryProvider(categoryId);
            Collection<String> autoIds = provider.getAutomaticIds(categoryId);
            if (autoIds.isEmpty()) continue;
            HashMap<String, Object> categoryInfo = new HashMap<String, Object>();
            categoryInfo.put("id", categoryId);
            categoryInfo.put("title", category.getTitle());
            categoryInfo.put("count", autoIds.size());
            categoryWithAutoNewsletters.add(categoryInfo);
        }
        params.put("categories-with-auto-newsletters", categoryWithAutoNewsletters);
        params.put("auto-newsletter-count", categoryWithAutoNewsletters.size());
        params.put("available-auto-newsletter-count", this._autoNewsletterEP.getExtensionsIds().size());
        return params;
    }
}

