/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.newsletter.auto.AutomaticNewsletter;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.commons.lang3.StringUtils;

public class StaticAutomaticNewsletter
extends AbstractLogEnabled
implements AutomaticNewsletter,
Configurable,
PluginAware {
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected I18nizableText _newsletterTitle;
    protected AutomaticNewsletter.FrequencyType _frequencyType;
    protected List<Integer> _dayNumbers;
    protected Map<String, String> _filters;
    protected String _pluginName;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] filterConfigurations;
        this._label = this._parseI18nizableText(configuration, "label");
        this._description = this._parseI18nizableText(configuration, "description");
        this._newsletterTitle = this._parseI18nizableText(configuration, "newsletter-title");
        Configuration frequencyConf = configuration.getChild("frequency");
        String frequencyType = frequencyConf.getAttribute("type");
        String dayNumbersStr = frequencyConf.getValue();
        this._frequencyType = AutomaticNewsletter.FrequencyType.valueOf(frequencyType.toUpperCase());
        this._dayNumbers = new ArrayList<Integer>();
        for (String dayNumber : StringUtils.split((String)dayNumbersStr, (String)", ")) {
            try {
                int number = Integer.parseInt(dayNumber);
                this._dayNumbers.add(number);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Error parsing the day numbers.", configuration, (Throwable)e);
            }
        }
        this._filters = new HashMap<String, String>();
        for (Configuration filterConf : filterConfigurations = configuration.getChild("filters").getChildren("filter")) {
            String name = filterConf.getAttribute("name");
            String id = filterConf.getAttribute("id");
            this._filters.put(name, id);
        }
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public I18nizableText getNewsletterTitle() {
        return this._newsletterTitle;
    }

    @Override
    public AutomaticNewsletter.FrequencyType getFrequencyType() {
        return this._frequencyType;
    }

    @Override
    public Collection<Integer> getDayNumbers() {
        return Collections.unmodifiableList(this._dayNumbers);
    }

    @Override
    public Map<String, String> getFilters() {
        return Collections.unmodifiableMap(this._filters);
    }

    protected I18nizableText _parseI18nizableText(Configuration config, String name) throws ConfigurationException {
        Configuration textConfig = config.getChild(name);
        boolean i18nSupported = textConfig.getAttributeAsBoolean("i18n", false);
        String text = textConfig.getValue("");
        if (i18nSupported) {
            Object catalogue = textConfig.getAttribute("catalogue", null);
            if (catalogue == null) {
                catalogue = "plugin." + this._pluginName;
            }
            return new I18nizableText((String)catalogue, text);
        }
        return new I18nizableText(text);
    }
}

