/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.io.InputStream;
import java.util.Date;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class NewsletterTemplate
extends AbstractLogEnabled
implements Serviceable,
Component {
    private SourceResolver _sourceResolver;
    private String _id;
    private String _skinId;
    private I18nizableText _label;
    private I18nizableText _description;
    private String _smallImage;
    private String _mediumImage;
    private String _largeImage;
    private long _lastConfUpdate;

    public NewsletterTemplate(String skinId, String templateId) {
        this._skinId = skinId;
        this._id = templateId;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public String getId() {
        return this._id;
    }

    public I18nizableText getLabel() {
        return this._label;
    }

    public I18nizableText getDescription() {
        return this._description;
    }

    public String getSmallImage() {
        return this._smallImage;
    }

    public String getMediumImage() {
        return this._mediumImage;
    }

    public String getLargeImage() {
        return this._largeImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshValues() {
        Source configurationFile;
        block11: {
            configurationFile = null;
            try {
                configurationFile = this._sourceResolver.resolveURI("skin:" + this._skinId + "://newsletter/" + this._id + "/template.xml");
                if (configurationFile.exists()) {
                    if (this._lastConfUpdate >= configurationFile.getLastModified()) break block11;
                    this._defaultValues();
                    this._lastConfUpdate = configurationFile.getLastModified();
                    try (InputStream is = configurationFile.getInputStream();){
                        Configuration configuration = new DefaultConfigurationBuilder().build(is);
                        this._label = this._configureI18n(configuration.getChild("label", false), this._label);
                        this._description = this._configureI18n(configuration.getChild("description", false), this._description);
                        this._smallImage = this._configureThumbnail(configuration.getChild("thumbnail").getChild("small").getValue(null), this._smallImage);
                        this._mediumImage = this._configureThumbnail(configuration.getChild("thumbnail").getChild("medium").getValue(null), this._mediumImage);
                        this._largeImage = this._configureThumbnail(configuration.getChild("thumbnail").getChild("marge").getValue(null), this._largeImage);
                        break block11;
                    }
                }
                this._defaultValues();
            }
            catch (Exception e) {
                try {
                    this._defaultValues();
                }
                catch (Throwable throwable) {
                    this._sourceResolver.release(configurationFile);
                    throw throwable;
                }
                this._sourceResolver.release(configurationFile);
            }
        }
        this._sourceResolver.release(configurationFile);
    }

    private void _defaultValues() {
        this._lastConfUpdate = new Date().getTime();
        this._label = new I18nizableText(this._id);
        this._description = new I18nizableText("");
        this._smallImage = "/plugins/newsletter/resources/img/category/template_16.png";
        this._mediumImage = "/plugins/newsletter/resources/img/category/template_32.png";
        this._largeImage = "/plugins/newsletter/resources/img/category/template_48.png";
    }

    private I18nizableText _configureI18n(Configuration child, I18nizableText defaultValue) throws ConfigurationException {
        if (child != null) {
            String value = child.getValue();
            if (child.getAttributeAsBoolean("i18n", false)) {
                return new I18nizableText("skin." + this._skinId, value);
            }
            return new I18nizableText(value);
        }
        return defaultValue;
    }

    private String _configureThumbnail(String value, String defaultImage) {
        if (value == null) {
            return defaultImage;
        }
        return "/skins/" + this._skinId + "/newsletter/" + this._id + "/resources/" + value;
    }
}

