/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.testsending;

import java.io.InputStream;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.ametys.cms.data.NamedResource;
import org.ametys.cms.data.RichText;
import org.ametys.cms.transformation.LocalURIResolver;
import org.ametys.core.util.ImageResolverHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.web.WebHelper;
import org.ametys.web.editor.LocalURIResolver;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class NewsletterLocalURIResolver
extends LocalURIResolver {
    public static final String NEWSLETTER_LOCAL_DATA_TYPE = "newsletter-local";
    private Repository _repository;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._repository = (Repository)manager.lookup(Repository.class.getName());
    }

    public String getType() {
        return NEWSLETTER_LOCAL_DATA_TYPE;
    }

    public String resolve(String uri, boolean download, boolean absolute, boolean internal) {
        return this._resolve(uri, download, absolute, internal, null);
    }

    public String resolveImage(String uri, int height, int width, boolean download, boolean absolute, boolean internal) {
        String suffix = height != 0 || width != 0 ? "_" + height + "x" + width : null;
        return this._resolve(uri, download, absolute, internal, suffix);
    }

    public String resolveBoundedImage(String uri, int maxHeight, int maxWidth, boolean download, boolean absolute, boolean internal) {
        String suffix = maxHeight != 0 || maxWidth != 0 ? "_max" + maxHeight + "x" + maxWidth : null;
        return this._resolve(uri, download, absolute, internal, suffix);
    }

    public String resolveCroppedImage(String uri, int cropHeight, int cropWidth, boolean download, boolean absolute, boolean internal) {
        String suffix = cropHeight != 0 || cropWidth != 0 ? "_crop" + cropHeight + "x" + cropWidth : null;
        return this._resolve(uri, download, absolute, internal, suffix);
    }

    public String resolveImageAsBase64(String uri, int height, int width) {
        return this._resolveImageAsBase64(uri, height, width, 0, 0, 0, 0);
    }

    public String resolveBoundedImageAsBase64(String uri, int maxHeight, int maxWidth) {
        return this._resolveImageAsBase64(uri, 0, 0, maxHeight, maxWidth, 0, 0);
    }

    public String resolveCroppedImageAsBase64(String uri, int cropHeight, int cropWidth) {
        return this._resolveImageAsBase64(uri, 0, 0, 0, 0, cropHeight, cropWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _resolve(String uri, boolean download, boolean absolute, boolean internal, String suffix) {
        Session liveSession = null;
        try {
            liveSession = this._repository.login("live");
            LocalURIResolver.URIInfo infos = this.getInfos(uri, true, liveSession);
            Request request = ContextHelper.getRequest((Context)this._context);
            String siteName = WebHelper.getSiteName((Request)request, (AmetysObject)infos.getContent());
            String string = this._resolve(infos, uri, siteName, download, absolute, internal, suffix);
            return string;
        }
        catch (Exception e) {
            this.getLogger().warn("Cannot resolve link " + uri, (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (liveSession != null) {
                liveSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _resolveImageAsBase64(String uri, int height, int width, int maxHeight, int maxWidth, int cropHeight, int cropWidth) {
        Session liveSession = null;
        try {
            String string;
            block12: {
                liveSession = this._repository.login("live");
                LocalURIResolver.URIInfo infos = this.getInfos(uri, true, liveSession);
                RichText richText = (RichText)infos.getContent().getValue(infos.getAttribute());
                NamedResource attachment = richText.getAttachment(infos.getFilename());
                InputStream dataIs = attachment.getInputStream();
                try {
                    string = ImageResolverHelper.resolveImageAsBase64((InputStream)dataIs, (String)attachment.getMimeType(), (int)height, (int)width, (int)maxHeight, (int)maxWidth, (int)cropHeight, (int)cropWidth);
                    if (dataIs == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (dataIs != null) {
                            try {
                                dataIs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.getLogger().warn("Cannot resolve link " + uri);
                        String string2 = "";
                        return string2;
                    }
                }
                dataIs.close();
            }
            return string;
        }
        finally {
            if (liveSession != null) {
                liveSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMimeType(String uri) {
        Session liveSession = null;
        try {
            liveSession = this._repository.login("live");
            LocalURIResolver.URIInfo infos = this.getInfos(uri, true, liveSession);
            RichText richText = (RichText)infos.getContent().getValue(infos.getAttribute());
            NamedResource attachment = richText.getAttachment(infos.getFilename());
            String string = attachment.getMimeType();
            return string;
        }
        catch (Exception e) {
            this.getLogger().warn("Cannot resolve link " + uri);
            String string = "";
            return string;
        }
        finally {
            if (liveSession != null) {
                liveSession.logout();
            }
        }
    }
}

