/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 

function migrateSiteTrackerParameter(session)
{
    let sites = Repository.query("//element(*, ametys:site)", true, session);
    let handledSites = 0;
    sites.forEach(
        site => {
            let hasChange = false;
            let trackingProvider = site.getValue("tracking-provider");
            if (!trackingProvider)
            {
                if (site.hasDefinition("google-web-property-id"))
                {   
                    let id = site.getValue("google-web-property-id");
                    if (id)
                    {
                        site.setValue("tracking-provider", "web.analytics.ga");
                        hasChange = true;
                        handledSites++;
                    }
                }
            
                if (!hasChange && site.hasDefinition("piwik-id"))
                {   
                    let id = site.getValue("piwik-id");
                    if (id)
                    {
                        site.setValue("tracking-provider", "web.analytics.matomo");   
                        handledSites++;
                    }
                }
            }
        }
    );
    
    if (handledSites > 0)
    {
        session.save(); 
    }
    
    logger.info(handledSites + " handled site");
}


logger.debug("Migrating sites in default workspace");
migrateSiteTrackerParameter(Repository.session);
logger.debug("Migration sites in live workspace");
migrateSiteTrackerParameter(Repository.liveSession);
