<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:import href="workspace:web://stylesheets/template-default.xsl"/>
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
	<xsl:param name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">newsletter newsletter-list</xsl:variable>
    <xsl:variable name="is-empty" select="not(/Newsletters/newsletter)"/>    
	<xsl:variable name="common-service-name">service-newsletter-list</xsl:variable>
  
	
    <!-- +
         | HEAD
         + -->    

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$service-title"/>  
            <xsl:with-param name="default-title"><i18n:text i18n:key="NEWSLETTERS_SERVICE_LIST_DESCRIPTION" i18n:catalogue="plugin.newsletter"/></xsl:with-param>                   
        </xsl:call-template>
    </xsl:template>
    
        
    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
		<xsl:call-template name="rss"/>

        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>  
            <xsl:with-param name="default-title"><i18n:text i18n:key="NEWSLETTERS_SERVICE_LIST_DESCRIPTION" i18n:catalogue="plugin.newsletter"/></xsl:with-param>            
        </xsl:call-template>    
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="newsletter-list"/>            
    </xsl:template>    
    
    <!-- Template for the rss link -->
    <xsl:template name="rss">
        <xsl:if test="/Newsletters/rss/@url">
            <div class="rss">
                <a href="{$uri-prefix}/{/Newsletters/rss/@url}"><i18n:text i18n:key="NEWSLETTERS_SERVICE_LIST_RSS_FEED_ALT"/></a>
            </div>
        </xsl:if>           
    </xsl:template>    
    
    <!-- Template for list of archived newsletters -->
    <xsl:template name="newsletter-list">
		<xsl:if test="/Newsletters/newsletter">            
            <ul>
                <xsl:for-each select="/Newsletters/newsletter">
                    <li>
                        <xsl:attribute name="class">
                            <xsl:call-template name="common-utils-class"/>
                        </xsl:attribute>
                        <xsl:call-template name="newsletter-list-item"/>
                    </li>
                </xsl:for-each>
            </ul>    
		</xsl:if>            
    </xsl:template>
    
    <!-- Template for the description of the newsletter -->    
    <xsl:template name="newsletter-list-item">
        <a href="{$site-uri-prefix}/_wrapped-content/{@name}.html" title="{title}"><xsl:value-of select="title"/></a>
        <xsl:text> - </xsl:text>
        <i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="date"/></i18n:date>
        <xsl:if test="number">
            <xsl:text>, N°</xsl:text><xsl:value-of select="number"/>
        </xsl:if>    
    </xsl:template>   
	
</xsl:stylesheet>
