<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:anycontent="http://anwrt.com/anycontent/2.0"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
    <xsl:template match="/subscribers">
        <html>
            <head/>
            <body>
                <table>
                    <thead>
                    	<th><i18n:text i18n:key="PLUGINS_NEWSLETTER_SUBSCRIBERS_COLUMN_EMAIL"/></th>
                    	<th><i18n:text i18n:key="PLUGINS_NEWSLETTER_SUBSCRIBERS_COLUMN_SUBSCRIBED_AT"/></th>
                    </thead>
                    
                    <tbody>
                        <xsl:for-each select="subscriber">
                            <tr>
                            	<td><xsl:value-of select="email"/></td>
                            	<td style="mso-number-format:dd\/mm\/yyyy\;\@"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="long"><xsl:value-of select="subscribedAt"/></i18n:date></td>
                    		</tr>
                        </xsl:for-each>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
