<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:param name="contextPath"/>
	<xsl:param name="cms-context"/>
	<xsl:param name="lang"/>
	<xsl:param name="siteName"/>
	<xsl:param name="token"/>
	<xsl:param name="unsubscribe"/>
	
	<xsl:template match="/ActionResult">
		<html>
			<body id='default'>
				
				<div id="service-newsletter-form">
					<xsl:choose>
						<xsl:when test="unsubscribe = 'true'">
							<xsl:call-template name="confirm-msg"/>
						</xsl:when>
						<xsl:when test="unknown-subscriber = 'true'">
							<xsl:call-template name="unknown-subscriber"/>
						</xsl:when>
						<xsl:when test="unknown-category = 'true'">
							<xsl:call-template name="unknown-category"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="unsubscribe-form"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="unknown-subscriber">
		<h2><i18n:text i18n:key="NEWSLETTERS_SERVICE_UNSUBSCRIBE"/></h2>
		
		<i18n:text i18n:key="NEWSLETTERS_SERVICE_UNSUBSCRIBE_UNKNOWN"/>
	</xsl:template>
	
	<xsl:template name="unknown-category">
		<h2><i18n:text i18n:key="NEWSLETTERS_SERVICE_UNSUBSCRIBE"/></h2>
		
		<i18n:text i18n:key="NEWSLETTERS_SERVICE_UNSUBSCRIBE_UNKNOWN_CATEGORY"/>
	</xsl:template>
	
	<xsl:template name="confirm-msg">
		<h2><i18n:text i18n:key="NEWSLETTERS_SERVICE_UNSUBSCRIBE"/></h2>
		
		<i18n:translate>
			<i18n:text i18n:key="NEWSLETTERS_SERVICE_UNSUBSCRIBE_SUCCESS"/>
			<i18n:param><xsl:value-of select="categoryTitle"/></i18n:param>
		</i18n:translate>
	</xsl:template>
	
	<xsl:template name="unsubscribe-form">
		<h2><i18n:text i18n:key="NEWSLETTERS_SERVICE_UNSUBSCRIBE"/></h2>
		<i18n:translate>
			<i18n:text i18n:key="NEWSLETTERS_SERVICE_UNSUBSCRIBE_CONFIRM_TEXT"/>
			<i18n:param><xsl:value-of select="categoryTitle"/></i18n:param>
			<i18n:param><xsl:value-of select="siteTitle"/></i18n:param>
			<i18n:param><xsl:value-of select="email"/></i18n:param>
		</i18n:translate>
		
		<form method="post">
			<input type="hidden" name="token" value="{$token}"/>
			<input type="hidden" name="unsubscribe" value="true"/>
			<input type="hidden" name="categoryId" value="{categoryId}"/>
			<input type="hidden" name="email" value="{email}"/>
			
			<input type="submit" class="submit" value="NEWSLETTERS_SERVICE_UNSUBSCRIBE_CONFIRM_BTN" i18n:attr="value">
			</input>
		</form>
	</xsl:template>
	
</xsl:stylesheet>
