/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.ametys.cms.ObservationConstants;
import org.ametys.web.cache.pageelement.AbstractSimplePageElementCachePolicy;
import org.ametys.web.cache.pageelement.PageElementCachePolicy;

/**
 * {@link PageElementCachePolicy} for the newsletter archive service.
 */
public class NewsletterArchiveServiceCachePolicy extends AbstractSimplePageElementCachePolicy
{
    
    private static final Set<String> _TYPES = new HashSet<>();
    static
    {
        _TYPES.add("SERVICE:org.ametys.newsletter.service.ListService");
    }
    
    @Override
    public Set<String> getPageElementTypes()
    {
        return _TYPES;
    }

    @Override
    protected List<String> _getRemovingCacheEventIds(String workspace)
    {
        // The newsletter archive service only displays newsletter content titles: only react on content events.
        if ("default".equals(workspace))
        {
            return Arrays.asList(ObservationConstants.EVENT_CONTENT_ADDED,
                                 ObservationConstants.EVENT_CONTENT_MODIFIED,
                                 // The service displays only validated contents, even in the back-office.
                                 ObservationConstants.EVENT_CONTENT_VALIDATED,
                                 ObservationConstants.EVENT_CONTENT_DELETED,
                                 ObservationConstants.EVENT_CONTENT_UNTAG_LIVE);
        }
        else if ("live".equals(workspace))
        {
            return Arrays.asList(ObservationConstants.EVENT_CONTENT_ADDED,
                                 ObservationConstants.EVENT_CONTENT_VALIDATED,
                                 ObservationConstants.EVENT_CONTENT_DELETED,
                                 ObservationConstants.EVENT_CONTENT_UNTAG_LIVE);
        }
        
        return Collections.emptyList();
    }
    
}
