/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter;

import java.util.Arrays;

import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.site.CopyUpdater;

/**
 * Copy updater for newsletters content
 *
 */
public class NewsletterCopyUpdater extends AbstractLogEnabled implements CopyUpdater, ThreadSafe, Serviceable
{
    private AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }

    @Override
    public void updateContent(Site initialSite, Site createdSite, Content initialContent, Content createdContent)
    {
        try
        {
            if (Arrays.asList(createdContent.getTypes()).contains("org.ametys.plugins.newsletter.Content.newsletter"))
            {
                String category = createdContent.getInternalDataHolder().getValue("category");
                if (category.startsWith("category_page://"))
                {
                    String pageId = category.substring("category_".length());
                    Page initialPage = _resolver.resolveById(pageId);
                    
                    try
                    {
                        // Find symetric copied page
                        Page copiedPage = createdSite.getSitemap(initialPage.getSitemapName()).getChild(initialPage.getPathInSitemap());
                        createdContent.getInternalDataHolder().setValue("category", "category_" + copiedPage.getId());
                    }
                    catch (UnknownAmetysObjectException e)
                    {
                        createdContent.getInternalDataHolder().removeValue("category");
                    }
                }
            }
        }
        catch (AmetysRepositoryException e)
        {
            getLogger().warn("[Site copy] Unable to update newsletter category for content '" + createdContent.getId() + "'", e);
        }
        
    }

    @Override
    public void updatePage(Site initialSite, Site createdSite, Page page)
    {
        // Nothing to do
    }
    
    @Override
    public void updateSite(Site initialSite, Site createdSite)
    {
        // Nothing to do
    }

}
