/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter.category;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * This class represent a category of newsletter
 */
public class Category
{
    private String _id;
    private String _name;
    private I18nizableText _title;
    private I18nizableText _description;
    private String _parentId;
    private String _template;
    private String _siteName;
    private String _lang;
    
    /**
     * Constructor
     * @param id The id of the tag. The id must be unique.
     */
    public Category (String id)
    {
        _id = id;
    }
    
    /**
     * Constructor
     * @param id The id of the category. The id must be unique.
     * @param name The name of the category. The name must be unique. The name is the same as the id except for JCR category.
     * @param parentId The parent category id
     * @param title the category title
     * @param description the category description
     * @param template the template
     * @param siteName the category site name
     * @param lang the category language
     */
    public Category(String id, String name, String parentId, I18nizableText title, I18nizableText description, String template, String siteName, String lang)
    {
        _id = id;
        _name = name;
        _parentId = parentId;
        _title = title;
        _description = description;
        _template = template;
        _siteName = siteName;
        _lang = lang;
    }
    
    
    /**
     * Get the category unique id. 
     * @return The unique id
     */
    public String getId ()
    {
        return _id;
    }
    
    /**
     * Get the category unique id. 
     * @return The unique id
     */
    public String getName ()
    {
        return _name;
    }
    
    /**
     * Get the parent id. 
     * @return The parent id. 
     */
    public String getParentId ()
    {
        return _parentId;
    }
    
    /**
     * Retrieves the title.
     * @return the title.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public I18nizableText getTitle()
    {
        return _title;
    }
    
    /**
     * Set the title.
     * @param title the title to set.
     */
    public void setTitle(I18nizableText title)
    {
        _title = title;
    }
    
    /**
     * Retrieves the description.
     * @return the description.
     */
    public I18nizableText getDescription()
    {
        return _description;
    }
    
    /**
     * Set the description.
     * @param description the description to set.
     */
    public void setDescription(I18nizableText description)
    {
        _description = description;
    }
    
    /**
     * Get the template name
     * @return the template name
     */
    public String getTemplate ()
    {
        return _template;
    }
    
    /**
     * Set the template 
     * @param templateName the template
     */
    public void setTemplate (String templateName)
    {
        _template = templateName;
    }
    
    /**
     * Get the the site name 
     * @return the the site name 
     */
    public String getSiteName ()
    {
        return _siteName;
    }
    
    /**
     * Set the site name 
     * @param siteName the site name to set
     */
    public void setSiteName (String siteName)
    {
        _siteName = siteName;
    }
    
    /**
     * Get the language
     * @return the language
     */
    public String getLang ()
    {
        return _lang;
    }
    
    /**
     * Set the language 
     * @param lang the language
     */
    public void setLang (String lang)
    {
        _lang = lang;
    }
}
