/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.newsletter.testsending;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.util.URIUtils;


/**
 * This class parses and resolve links using ResolveLinkComponent
 */
public final class HTMLExpertLinkResolver
{
    private static final Pattern __PARSER = Pattern.compile("\\$\\{type:([^#]+)#url:([^#]+)#download:(true|false)\\}");
    
    private HTMLExpertLinkResolver()
    {
        // Utility
    }
    
    /**
     * Parse a html string and resolve link found
     * @param htmlexpert The htmlexpert string 
     * @param idDataHolderContent The id of the content holding the data. Can be null to keep the uri as is
     * @return The string with links resolved
     */
    public static String parseAndResolve(String htmlexpert, String idDataHolderContent)
    {
        String s = URIUtils.decode(htmlexpert);
        
        Matcher m = __PARSER.matcher(s);
        while (m.find())
        {
            String type = m.group(1);
            String uri = m.group(2);
            boolean download = "true".equals(m.group(3));
            
            if ("local".equals(type) && StringUtils.isNotEmpty(idDataHolderContent))
            {
                uri = idDataHolderContent + "@" + StringUtils.substringAfter(uri, "@");
                type = NewsletterLocalURIResolver.NEWSLETTER_LOCAL_DATA_TYPE;
            }
            
            s = s.substring(0, m.start()) + ResolveURIComponent.resolve(type, uri, download) + s.substring(m.end());
            
            m.reset(s);
        }
        
        return s;
    }
}
