/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.workflow.SendMailEngine;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.content.ModifiableWebContent;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.content.jcr.DefaultWebContent;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class NewsletterDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = NewsletterDAO.class.getName();
    public static final String __SEND_TESTING_RIGHT = "Plugins_Newsletter_Right_TestSending";
    public static final String __NEWSLETTER_CONTENT_TYPE = "org.ametys.plugins.newsletter.Content.newsletter";
    public static final String __TEST_UNIQUE_ID_METADATA = "test-unique-id";
    private AmetysObjectResolver _resolver;
    private CurrentUserProvider _currentUserProvider;
    private RenderingContextHandler _renderingContextHandler;
    private SourceResolver _sourceResolver;
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private Context _context;
    private SiteManager _siteManager;
    private Repository _repository;
    private I18nUtils _i18nUtils;
    private UserLanguagesManager _userLanguagesManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)smanager.lookup(RenderingContextHandler.ROLE);
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._repository = (Repository)smanager.lookup(Repository.class.getName());
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)smanager.lookup(UserLanguagesManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable(rights={"Plugins_Newsletter_Right_ValidateNewsletters"}, paramIndex=0, rightContext="right.assignment.context.content")
    public boolean isSent(String newsletterId) {
        Content content = (Content)this._resolver.resolveById(newsletterId);
        return (Boolean)content.getInternalDataHolder().getValue("sent", (Object)false);
    }

    public Map<String, Object> getNewsletterProperties(Content newsletter) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", newsletter.getId());
        infos.put("title", newsletter.getTitle());
        infos.put("name", newsletter.getName());
        infos.put("automatic", newsletter.getInternalDataHolder().getValue("automatic", (Object)false));
        return infos;
    }

    @Callable(rights={"Plugins_Newsletter_Right_TestSending"})
    public boolean sendTestNewsletter(String newsletterId, String recipientEmail) throws IllegalAccessException {
        String uid;
        ModifiableWebContent content = (ModifiableWebContent)this._resolver.resolveById(newsletterId);
        if (!(content instanceof DefaultWebContent)) {
            throw new UnknownAmetysObjectException("Unable to send newsletter, invalid newsletter id provider '" + newsletterId + "'");
        }
        this.getLogger().info("The user {} sent the newsletter {} to {}", new Object[]{this._currentUserProvider.getUser(), newsletterId, recipientEmail});
        ModifiableModelLessDataHolder internalDataHolder = content.getInternalDataHolder();
        if (!internalDataHolder.hasValue(__TEST_UNIQUE_ID_METADATA)) {
            uid = UUID.randomUUID().toString();
            internalDataHolder.setValue(__TEST_UNIQUE_ID_METADATA, (Object)uid);
            content.saveChanges();
        } else {
            uid = (String)internalDataHolder.getValue(__TEST_UNIQUE_ID_METADATA, null);
        }
        String siteName = (String)ContextHelper.getRequest((Context)this._context).getAttribute("siteName");
        Site site = this._siteManager.getSite(siteName);
        boolean includeImages = (Boolean)site.getValue("newsletter-mail-include-images", false, (Object)false);
        String dataHolderUid = null;
        if (!includeImages && uid != null) {
            dataHolderUid = this._useDataHolderContent(site, (WebContent)content, uid);
        }
        try {
            this.sendNewsletter((DefaultWebContent)content, (Map<String, String>)ImmutableMap.of((Object)recipientEmail, (Object)"#token#"), dataHolderUid);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to send the newsletter", (Throwable)e);
            return false;
        }
        return true;
    }

    private String _useDataHolderContent(Site site, WebContent realContent, String uid) {
        try {
            RichText richText = (RichText)realContent.getValue("content");
            if (!richText.getAttachmentNames().isEmpty()) {
                return this._createDataHolderContent(site, realContent, uid, richText);
            }
        }
        catch (IOException | RepositoryException e) {
            this.getLogger().error("A repository error occurred when creating the data holder temporary content, when sending a test newsletter", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _createDataHolderContent(Site site, WebContent realContent, String uid, RichText richText) throws RepositoryException, IOException {
        Session liveSession = null;
        try {
            liveSession = this._repository.login("live");
            ModifiableTraversableAmetysObject siteContents = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath(site.getPath() + "/ametys-internal:contents");
            ModifiableTraversableAmetysObject liveSiteContents = (ModifiableTraversableAmetysObject)this._resolver.resolveById(siteContents.getId(), liveSession);
            String contentName = realContent.getName() + "-test-" + uid;
            ModifiableWebContent dataHolderContent = null;
            if (!liveSiteContents.hasChild(contentName)) {
                dataHolderContent = (ModifiableWebContent)liveSiteContents.createChild(contentName, "ametys:defaultWebContent");
                dataHolderContent.setTypes(new String[]{__NEWSLETTER_CONTENT_TYPE});
                dataHolderContent.setTitle(realContent.getTitle());
                dataHolderContent.setSiteName(realContent.getSiteName());
                dataHolderContent.setLanguage(realContent.getLanguage());
                dataHolderContent.setLastModified(realContent.getLastModified());
            } else {
                dataHolderContent = (ModifiableWebContent)liveSiteContents.getChild(contentName);
            }
            richText.setInputStream((InputStream)new ByteArrayInputStream("unused".getBytes(StandardCharsets.UTF_8)));
            dataHolderContent.setValue("content", (Object)richText);
            dataHolderContent.saveChanges();
            String string = dataHolderContent.getId();
            return string;
        }
        finally {
            if (liveSession != null) {
                liveSession.logout();
            }
        }
    }

    public void sendNewsletter(DefaultWebContent content, Map<String, String> recipients) throws IOException {
        this.sendNewsletter(content, recipients, null);
    }

    public void sendNewsletter(DefaultWebContent content, Map<String, String> recipients, String dataHolderId) throws IOException {
        String language = (String)StringUtils.defaultIfBlank((CharSequence)content.getLanguage(), (CharSequence)this._userLanguagesManager.getDefaultLanguage());
        String subject = this._getSubject(content, language);
        String htmlBody = this._getBodyAsHtml(content, dataHolderId, language);
        String textBody = this._getBodyAsText(content, dataHolderId, language);
        Site site = content.getSite();
        String sender = (String)site.getValue("newsletter-mail-sender");
        SendMailEngine sendEngine = new SendMailEngine();
        sendEngine.parameterize(subject, htmlBody, textBody, recipients, sender);
        new Thread(sendEngine).start();
    }

    protected String _getSubject(DefaultWebContent content, String language) {
        ArrayList<String> i18nparam = new ArrayList<String>();
        i18nparam.add(content.getSite().getTitle());
        i18nparam.add(content.getTitle());
        i18nparam.add(String.valueOf(content.getValue("newsletter-number", false, (Object)0L)));
        String categoryId = (String)content.getInternalDataHolder().getValue("category");
        Category category = this.getCategory(categoryId);
        i18nparam.add(category != null ? category.getTitle().getLabel() : "");
        I18nizableText i18nTextSubject = new I18nizableText("plugin.newsletter", "PLUGINS_NEWSLETTER_SEND_MAIL_SUBJECT", i18nparam);
        return this._i18nUtils.translate((I18nizable)i18nTextSubject, language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _getBodyAsHtml(DefaultWebContent content, String dataHolderId, String language) throws IOException {
        String string;
        SitemapSource src = null;
        Request request = ContextHelper.getRequest((Context)this._context);
        Site site = content.getSite();
        boolean includeImages = (Boolean)site.getValue("newsletter-mail-include-images", false, (Object)false);
        if (includeImages) {
            request.setAttribute("forceBase64Encoding", (Object)true);
        }
        RenderingContext renderingContext = this._renderingContextHandler.getRenderingContext();
        try {
            this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
            String uri = "cocoon://_content.mail?contentId=" + content.getId() + "&site=" + content.getSiteName() + "&lang=" + language + "&_contextPath=" + content.getSite().getUrl();
            if (StringUtils.isNotEmpty((CharSequence)dataHolderId)) {
                uri = uri + "&useDataHolderContent=" + dataHolderId;
            }
            src = (SitemapSource)this._sourceResolver.resolveURI(uri);
            InputStreamReader reader = new InputStreamReader(src.getInputStream(), "UTF-8");
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            this._sourceResolver.release(src);
            this._renderingContextHandler.setRenderingContext(renderingContext);
            request.removeAttribute("forceBase64Encoding");
            throw throwable;
        }
        this._sourceResolver.release((Source)src);
        this._renderingContextHandler.setRenderingContext(renderingContext);
        request.removeAttribute("forceBase64Encoding");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _getBodyAsText(DefaultWebContent content, String dataHolderId, String language) throws IOException {
        String string;
        SitemapSource src = null;
        RenderingContext renderingContext = this._renderingContextHandler.getRenderingContext();
        try {
            this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
            String uri = "cocoon://_content.text?contentId=" + content.getId() + "&site=" + content.getSiteName() + "&lang=" + language + "&_contextPath=" + content.getSite().getUrl();
            if (StringUtils.isNotEmpty((CharSequence)dataHolderId)) {
                uri = uri + "&useDataHolderContent=" + dataHolderId;
            }
            src = (SitemapSource)this._sourceResolver.resolveURI(uri);
            InputStreamReader reader = new InputStreamReader(src.getInputStream(), "UTF-8");
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            this._sourceResolver.release(src);
            this._renderingContextHandler.setRenderingContext(renderingContext);
            throw throwable;
        }
        this._sourceResolver.release((Source)src);
        this._renderingContextHandler.setRenderingContext(renderingContext);
        return string;
    }

    public Category getCategory(String categoryID) {
        Set ids = this._categoryProviderEP.getExtensionsIds();
        for (String id : ids) {
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
            if (categoryID.startsWith("provider_") || !provider.hasCategory(categoryID)) continue;
            return provider.getCategory(categoryID);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestNewsletter(WebContent content, Site site) throws RepositoryException {
        if (content.getInternalDataHolder().hasValue(__TEST_UNIQUE_ID_METADATA)) {
            Session liveSession = null;
            try {
                AmetysObject child;
                String testUniqueId = (String)content.getInternalDataHolder().getValue(__TEST_UNIQUE_ID_METADATA);
                liveSession = this._repository.login("live");
                ModifiableTraversableAmetysObject siteContents = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath(site.getPath() + "/ametys-internal:contents");
                ModifiableTraversableAmetysObject liveSiteContents = (ModifiableTraversableAmetysObject)this._resolver.resolveById(siteContents.getId(), liveSession);
                String contentName = content.getName() + "-test-" + testUniqueId;
                if (liveSiteContents.hasChild(contentName) && (child = liveSiteContents.getChild(contentName)) instanceof RemovableAmetysObject) {
                    ((RemovableAmetysObject)child).remove();
                    liveSiteContents.saveChanges();
                }
                content.getInternalDataHolder().removeValue(__TEST_UNIQUE_ID_METADATA);
            }
            finally {
                if (liveSession != null) {
                    liveSession.logout();
                }
            }
        }
    }
}

