/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.auto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.newsletter.auto.AutomaticNewsletter;
import org.ametys.plugins.newsletter.auto.AutomaticNewsletterExtensionPoint;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;

public class AutomaticNewsletterDAO
implements Serviceable,
Component {
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private AutomaticNewsletterExtensionPoint _autoNewsletterEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._autoNewsletterEP = (AutomaticNewsletterExtensionPoint)((Object)manager.lookup(AutomaticNewsletterExtensionPoint.ROLE));
    }

    @Callable(rights={"Plugins_Newsletter_Right_SetAutomatic"})
    public void setAutomaticNewsletters(String categoryId, List<String> autoNewslettersIds) throws ProcessingException {
        if (StringUtils.isEmpty((CharSequence)categoryId) || !this._categoryProviderEP.hasCategory(categoryId)) {
            throw new ProcessingException("Unknown category ID: " + categoryId);
        }
        CategoryProvider provider = this._categoryProviderEP.getCategoryProvider(categoryId);
        provider.setAutomatic(categoryId, autoNewslettersIds);
    }

    @Callable(rights={"Plugins_Newsletter_Right_SetAutomatic"})
    public List<Map<String, Object>> getAutomaticNewsletters() {
        ArrayList<Map<String, Object>> autoNewsletters = new ArrayList<Map<String, Object>>();
        for (String autoNewsletterId : this._autoNewsletterEP.getExtensionsIds()) {
            AutomaticNewsletter autoNewsletter = (AutomaticNewsletter)this._autoNewsletterEP.getExtension(autoNewsletterId);
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("id", autoNewsletterId);
            infos.put("label", autoNewsletter.getLabel());
            infos.put("description", autoNewsletter.getDescription());
            HashMap<String, Object> frequency = new HashMap<String, Object>();
            frequency.put("type", autoNewsletter.getFrequencyType().toString().toLowerCase());
            frequency.put("dayNumbers", autoNewsletter.getDayNumbers());
            infos.put("frequency", frequency);
            infos.put("filters", autoNewsletter.getFilters());
            autoNewsletters.add(infos);
        }
        return autoNewsletters;
    }
}

