/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.category;

import java.util.ArrayList;
import java.util.Collection;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class CategoryProviderExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<CategoryProvider> {
    public static final String ROLE = CategoryProviderExtensionPoint.class.getName();

    public Collection<Category> getCategories(String siteName, String language) {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (String id : this.getExtensionsIds()) {
            CategoryProvider provider = (CategoryProvider)this.getExtension(id);
            categories.addAll(provider.getCategories(siteName, language));
        }
        return categories;
    }

    public Category getCategory(String categoryId) {
        for (String id : this.getExtensionsIds()) {
            CategoryProvider provider = (CategoryProvider)this.getExtension(id);
            if (!provider.hasCategory(categoryId)) continue;
            return provider.getCategory(categoryId);
        }
        return null;
    }

    public boolean hasCategory(String categoryId) {
        for (String id : this.getExtensionsIds()) {
            CategoryProvider provider = (CategoryProvider)this.getExtension(id);
            if (!provider.hasCategory(categoryId)) continue;
            return true;
        }
        return false;
    }

    public CategoryProvider getCategoryProvider(String categoryId) {
        for (String id : this.getExtensionsIds()) {
            CategoryProvider provider = (CategoryProvider)this.getExtension(id);
            if (!provider.hasCategory(categoryId)) continue;
            return provider;
        }
        return null;
    }
}

