/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.subscribe;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class SubscribersClientSideElement
extends StaticClientSideElement {
    private static final Pattern __EMAIL_VALIDATOR = SendMailHelper.EMAIL_VALIDATION;
    protected SubscribersDAO _subscribersDao;
    protected CategoryProviderExtensionPoint _categoryProviderEP;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._subscribersDao = (SubscribersDAO)((Object)smanager.lookup(SubscribersDAO.ROLE));
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
    }

    @Callable(rights={"Plugins_Newsletter_Right_HandleSubscribers"})
    public Map<String, Object> addSubscribers(String siteName, String categoryId, String emailsList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Category category = this._categoryProviderEP.getCategory(categoryId);
        if (category == null) {
            return Collections.singletonMap("error", "unknown-category");
        }
        Collection<String> emails = this.getEmails(emailsList);
        if (!emails.isEmpty()) {
            this.insertSubscribers(emails, categoryId, siteName, result);
        } else {
            result.put("subscribedCount", "0");
            result.put("existingCount", "0");
            result.put("errorCount", "0");
        }
        result.put("success", "true");
        result.put("categoryId", categoryId);
        return result;
    }

    protected Collection<String> getEmails(String emailsList) {
        String[] part;
        LinkedHashSet<String> emails = new LinkedHashSet<String>();
        for (String line : part = emailsList.split("[;\n]")) {
            String email = StringUtils.trimToEmpty((String)line);
            if (__EMAIL_VALIDATOR.matcher(email.toLowerCase()).matches() && StringUtils.isNotBlank((CharSequence)email)) {
                emails.add(email);
                continue;
            }
            this.getLogger().warn("Import subscribers email: '" + email + "' is not a valid email; it will be ignored");
        }
        return emails;
    }

    protected void insertSubscribers(Collection<String> emails, String categoryId, String siteName, Map<String, Object> result) {
        int subscribedCount = 0;
        int existingCount = 0;
        int errorCount = 0;
        for (String email : emails) {
            if (this._subscribersDao.getSubscriber(email, siteName, categoryId) == null) {
                Subscriber subscriber = new Subscriber();
                subscriber.setEmail(email);
                subscriber.setSiteName(siteName);
                subscriber.setCategoryId(categoryId);
                subscriber.setSubscribedAt(new Date());
                String token = UUID.randomUUID().toString();
                subscriber.setToken(token);
                this._subscribersDao.subscribe(subscriber);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("The user with email '" + email + "' subscribed to the newsletter with the token " + token);
                }
                ++subscribedCount;
                continue;
            }
            ++existingCount;
        }
        result.put("subscribedCount", Integer.toString(subscribedCount));
        result.put("existingCount", Integer.toString(existingCount));
        result.put("errorCount", Integer.toString(errorCount));
    }

    @Callable(rights={"Plugins_Newsletter_Right_HandleSubscribers"})
    public Map<String, Object> removeSubscribers(String siteName, String categoryId, List<String> emails) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Category category = this._categoryProviderEP.getCategory(categoryId);
        if (category == null) {
            return Collections.singletonMap("message", "unknown-category");
        }
        if (emails.size() > 0) {
            for (String email : emails) {
                Subscriber subscriber = this._subscribersDao.getSubscriber(email, siteName, categoryId);
                if (subscriber != null) {
                    String token = subscriber.getToken();
                    this._subscribersDao.unsubscribe(token, SubscribersDAO.UnsubscribeOrigin.ADMINISTRATOR);
                    if (!this.getLogger().isInfoEnabled()) continue;
                    this.getLogger().info("The user with email '" + email + "' unsubscribed from the newsletter in category " + categoryId + " of site " + siteName);
                    continue;
                }
                this.getLogger().error("Impossible to find and remove from the newsletter the subscriber with email '" + email + "' in category " + categoryId + " of site " + siteName);
            }
        }
        return result;
    }
}

