/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.subscribe;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.plugins.newsletter.daos.Subscriber;
import org.ametys.plugins.newsletter.daos.SubscribersDAO;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class UnsubscribeAction
extends ServiceableAction {
    private SubscribersDAO _subscribersDao;
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private SiteManager _siteManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._subscribersDao = (SubscribersDAO)((Object)smanager.lookup(SubscribersDAO.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        boolean unsubscribe = request.getParameter("unsubscribe") != null;
        String token = request.getParameter("token");
        result.put("token", "token");
        if (unsubscribe) {
            this._subscribersDao.unsubscribe(token, SubscribersDAO.UnsubscribeOrigin.SUBSCRIBER);
            String categoryID = request.getParameter("categoryId");
            Category category = this._getCategory(categoryID);
            if (category != null) {
                result.put("categoryId", category.getId());
                result.put("categoryTitle", category.getTitle().getLabel());
            }
            result.put("unsubcribe", "true");
        } else {
            Subscriber subscriber = this._subscribersDao.getSubscriberByToken(token);
            if (subscriber != null) {
                String categoryID;
                Category category;
                String email = subscriber.getEmail();
                result.put("email", email);
                String sitename = subscriber.getSiteName();
                Site site = this._siteManager.getSite(sitename);
                if (site != null) {
                    result.put("siteTitle", site.getTitle());
                }
                if ((category = this._getCategory(categoryID = subscriber.getCategoryId())) != null) {
                    result.put("categoryId", category.getId());
                    result.put("categoryTitle", category.getTitle().getLabel());
                } else {
                    result.put("unknown-category", "true");
                }
            } else {
                result.put("unknown-subscriber", "true");
            }
        }
        return result;
    }

    private Category _getCategory(String categoryID) {
        Set ids = this._categoryProviderEP.getExtensionsIds();
        for (String id : ids) {
            CategoryProvider provider = (CategoryProvider)this._categoryProviderEP.getExtension(id);
            if (!provider.hasCategory(categoryID)) continue;
            return provider.getCategory(categoryID);
        }
        return null;
    }
}

