/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.newsletter.userpref;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.model.type.ModelItemTypeExtensionPoint;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferenceProvider;
import org.ametys.plugins.newsletter.category.Category;
import org.ametys.plugins.newsletter.category.CategoryProvider;
import org.ametys.plugins.newsletter.category.CategoryProviderExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class NewsletterUserPreferenceProvider
extends AbstractLogEnabled
implements UserPreferenceProvider,
Serviceable {
    protected static final I18nizableText _NEWSLETTER_PREF_GROUP = new I18nizableText("plugin.newsletter", "PLUGINS_NEWSLETTER_USER_PREFERENCES_GROUP");
    protected static final String _NEWSLETTER_PREF_STORAGE_COMPONENT = "org.ametys.plugins.newsletter.userpref.NewsletterUserPreferencesStorage";
    protected CategoryProviderExtensionPoint _categoryEP;
    protected ModelItemTypeExtensionPoint _userPreferenceTypeExtensionPoint;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._categoryEP = (CategoryProviderExtensionPoint)((Object)serviceManager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._userPreferenceTypeExtensionPoint = (ModelItemTypeExtensionPoint)serviceManager.lookup(ModelItemTypeExtensionPoint.ROLE_USER_PREFERENCES);
    }

    public Collection<UserPreference> getPreferences(Map<String, String> contextVars) {
        HashSet<UserPreference> prefs = new HashSet<UserPreference>();
        String siteName = contextVars.get("siteName");
        String sitemapName = contextVars.get("sitemapLanguage");
        if (StringUtils.isNotEmpty((CharSequence)siteName) && StringUtils.isNotEmpty((CharSequence)sitemapName)) {
            for (String categoryProviderId : this._categoryEP.getExtensionsIds()) {
                CategoryProvider categoryProvider = (CategoryProvider)this._categoryEP.getExtension(categoryProviderId);
                MutableInt index = new MutableInt(1);
                List<Category> categories = categoryProvider.getCategories(siteName, sitemapName);
                this.fillUserPreferences(prefs, categories, categoryProvider, index);
            }
        }
        return prefs;
    }

    protected void fillUserPreferences(Set<UserPreference> prefs, List<Category> categories, CategoryProvider categoryProvider, MutableInt index) {
        for (Category category : categories) {
            prefs.add(this.getCategoryUserPref(category, index.intValue()));
            index.increment();
            List<Category> subCategories = categoryProvider.getCategories(category.getId());
            this.fillUserPreferences(prefs, subCategories, categoryProvider, index);
        }
    }

    protected UserPreference getCategoryUserPref(Category category, int index) {
        UserPreference pref = new UserPreference();
        HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
        params.put("category", category.getTitle());
        I18nizableText label = new I18nizableText("plugin.newsletter", "PLUGINS_NEWSLETTER_USER_PREFERENCES_LABEL", params);
        pref.setName(category.getId());
        pref.setLabel(label);
        pref.setDescription(category.getDescription());
        pref.setType((ModelItemType)this._userPreferenceTypeExtensionPoint.getExtension("boolean"));
        pref.setPluginName("newsletter");
        pref.setManagerRole(_NEWSLETTER_PREF_STORAGE_COMPONENT);
        pref.setDisplayGroup(_NEWSLETTER_PREF_GROUP);
        pref.setPosition((long)index);
        return pref;
    }
}

