<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:param name="contextPath"/>
    <xsl:param name="cms-context"/>
    
    <xsl:template match="/Newsletters">
        <rss version="2.0">
            <channel>
                <title>
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_NEWSLETTER_ARCHIVES_RSS_TITLE"/>
                        <i18n:param name="category"><xsl:value-of select="category/title"/></i18n:param>
                    </i18n:translate>
                </title>
                <description>
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_NEWSLETTER_ARCHIVES_RSS_DESCRIPTION"/>
                        <i18n:param name="category"><xsl:value-of select="category/title"/></i18n:param>
                    </i18n:translate>
                </description>
                <pubDate><i18n:date pattern="EEE, d MMM yyyy HH:mm:ss Z" src-pattern="yyyy-MM-dd'T'HH:mm:ss" locale="en_EN"/></pubDate>
                <link></link>
                <xsl:apply-templates select="newsletter">
                    <xsl:sort select="date/@millis" order="descending"/>
                </xsl:apply-templates>
            </channel>
        </rss>
    </xsl:template>
    
    <xsl:template match="newsletter">
        <item>
            <title><xsl:value-of select="title"/></title>
            <description>
                <xsl:call-template name="truncate">
                    <xsl:with-param name="content" select="newsletter-content/content/metadata/content/body"/>
                    <xsl:with-param name="length" select="'200'"/>
                </xsl:call-template>
            </description>
            <pubDate><i18n:date pattern="EEE, d MMM yyyy HH:mm:ss Z" src-pattern="yyyy-MM-dd'T'HH:mm:ss" locale="en_EN"><xsl:value-of select="date"/></i18n:date></pubDate>
            <link>
                <xsl:value-of select="$cms-context"/>
                <xsl:text>/_wrapped-content/</xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text>.html</xsl:text>
            </link>
        </item>
    </xsl:template>
    
    <!--
        Truncate a HTML (or text) block to a given maximum length, adding an ellipsis if needed.
        This function keeps whole words, i.e. never cuts the last word in two.
        Parameters:
            content - the root node of the HTML block to truncate.
            length - the maximum number of characters (default: 200).
            ellipsis - the text to add to the end of the block if the content was truncated (default: '...').
     -->
    <xsl:template name="truncate">
        <xsl:param name="content"/>
        <xsl:param name="length" select="200"/>
        <xsl:param name="ellipsis">...</xsl:param>
        <!-- "Internal" parameters used only for recursion. -->
        <xsl:param name="size">0</xsl:param>
        <xsl:param name="somethingremoved">false</xsl:param>
        <xsl:param name="iftoolong"/>
        <xsl:param name="initial">true</xsl:param>
        
        <xsl:choose>
            <!-- Filter unwanted content (video, query, html expert...) -->
            <xsl:when test="name($content) = 'html:htmlexpert' or name($content) = 'ametys:dataquery' or name($content) = 'docbook:videoobject' or name($content) = 'html:form' or name($content) = 'html:autooutline'">
                <xsl:call-template name="truncate">
                    <xsl:with-param name="content" select="$content/following-sibling::node()[1]"/>
                    <xsl:with-param name="length" select="$length" />
                    <xsl:with-param name="ellipsis" select="$ellipsis" />
                    <xsl:with-param name="size" select="number($size)"/>
                    <xsl:with-param name="iftoolong" select="$iftoolong"/>
                    <xsl:with-param name="somethingremoved" select="'true'"/>
                    <xsl:with-param name="initial" select="'false'"/>
                </xsl:call-template>
            </xsl:when>
            
            <xsl:otherwise>
                
                <xsl:variable name="computed-text">
                    <xsl:for-each select="$content//text()"><xsl:value-of select="."/></xsl:for-each>
                </xsl:variable>
                <xsl:variable name="text">
                    <xsl:choose>
                        <xsl:when test="string-length(normalize-space($computed-text)) != 0"><xsl:value-of select="$computed-text"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="$content"/></xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                
                <xsl:if test="string-length(normalize-space($content)) != 0">
                    <xsl:choose>
                        <xsl:when test="local-name($content) = ''">
                            <xsl:call-template name="no-wrap-text">
                                <xsl:with-param name="text" select="$text" />
                                <xsl:with-param name="length" select="$length" />
                                <xsl:with-param name="size" select="$size" />
                            </xsl:call-template>
                            <xsl:if test="$length - $size &lt; string-length($text)">
                                <xsl:value-of select="$ellipsis"/>
                            </xsl:if>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="truncate">
                                <xsl:with-param name="content" select="$content/node()[1]"/>
                                <xsl:with-param name="length" select="$length" />
                                <xsl:with-param name="ellipsis" select="$ellipsis" />
                                <xsl:with-param name="size" select="number($size)"/>
                                <xsl:with-param name="iftoolong" select="$iftoolong"/>
                                <xsl:with-param name="somethingremoved" select="'true'"/>
                                <xsl:with-param name="initial" select="'false'"/>
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                
                <xsl:if test="local-name($content) = 'p' or local-name($content) = 'div' or local-name($content) = 'h1' or local-name($content) = 'h2' or local-name($content) = 'h3' or local-name($content) = 'h4' or local-name($content) = 'h5'">
                    &lt;br/&gt;
                </xsl:if>
                
                <xsl:if test="number($size) + string-length($text) &lt; $length and count($content/following-sibling::node()) != 0">
                    <xsl:call-template name="truncate">
                        <xsl:with-param name="content" select="$content/following-sibling::node()[1]"/>
                        <xsl:with-param name="length" select="$length" />
                        <xsl:with-param name="ellipsis" select="$ellipsis" />
                        <xsl:with-param name="size" select="number($size) + string-length($text)"/>
                        <xsl:with-param name="iftoolong" select="$iftoolong"/>
                        <xsl:with-param name="somethingremoved" select="$somethingremoved"/>
                        <xsl:with-param name="initial" select="'false'"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:if test="$initial = 'true'">
            <xsl:variable name="cumuled">
                <xsl:for-each select="$content/..//text()"><xsl:value-of select="."/></xsl:for-each>
            </xsl:variable>
            
            <xsl:if test="(count($content/../p | $content/../*/p) != count($content/../* | $content/../*/*) or string-length($cumuled) &gt;= $length)">
                <xsl:copy-of select="$iftoolong"/>
            </xsl:if>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="no-wrap-text">
        <xsl:param name="text" />
        <xsl:param name="length" />
        <xsl:param name="size" />
        
        <xsl:variable name="first-length"><xsl:value-of select="string-length($text)" /></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="number($first-length) + number($size) &lt; number($length)">
                <xsl:value-of select="substring($text, 0, number($length) - number($size))"/>
            </xsl:when>
            
            <xsl:otherwise>
                <xsl:value-of select="ametys:splitText($text, ' ,.:(?!;', $length, $size)" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
