<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<!--DOCTYPE xsl:stylesheet PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "xhtml1-transitional.dtd"-->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:htmlexpertresolver="org.ametys.plugins.newsletter.testsending.HTMLExpertLinkResolver"
                exclude-result-prefixes="resolver ametys htmlexpertresolver">
    
    <xsl:param name="useDataHolderContent" select="ametys:requestParameter('useDataHolderContent')"/>

    <xsl:template match="img" priority="1">
        <img>
            <xsl:variable name="srcResolved">
                <xsl:choose>
                    <xsl:when test="$useDataHolderContent != '' and @data-ametys-type = 'local'">
                        <xsl:value-of select="resolver:resolveImage('newsletter-local', concat($useDataHolderContent, '@', substring-after(@href, '@')), substring-before(@height, 'px'), substring-before(@width, 'px'))"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="resolver:resolveImage(@data-ametys-type, @href, substring-before(@height, 'px'), substring-before(@width, 'px'))"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:attribute name="src">
                <xsl:call-template name="get-image-src">
                    <xsl:with-param name="srcResolved" select="$srcResolved"/>
                    <xsl:with-param name="width" select="@width"/>
                    <xsl:with-param name="height" select="@height"/>
                </xsl:call-template>
            </xsl:attribute>

            <xsl:copy-of select="@class"/>
			<xsl:copy-of select="@alt"/>
            
            <xsl:call-template name="image-title-attribute">
                <xsl:with-param name="srcResolved" select="$srcResolved"/>
            </xsl:call-template>
            
            <xsl:call-template name="image-style-attribute">
                <xsl:with-param name="srcResolved" select="$srcResolved"/>
                <xsl:with-param name="width" select="substring-before(@width, 'px')"/>
                <xsl:with-param name="height" select="substring-before(@height, 'px')"/>
            </xsl:call-template>
            
            <xsl:if test="@align">
            	 <xsl:copy-of select="@align"/>
            </xsl:if>
            
            <xsl:if test="@width">
            	 <xsl:copy-of select="@width"/>
            </xsl:if>
            
            <xsl:if test="@height">
            	 <xsl:copy-of select="@height"/>
            </xsl:if>
      	</img>
    </xsl:template>
    
    <xsl:template match="htmlexpert" priority="1">
    	<xsl:value-of disable-output-escaping="yes" select="htmlexpertresolver:parseAndResolve(., $useDataHolderContent)"/>
    </xsl:template>

</xsl:stylesheet>