<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2013 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:wa="org.ametys.plugins.newsletter.analytics.WebAnalyticsXsltHelper"
                extension-element-prefixes="ametys wa">
    
    <xsl:variable name="trackingEnabled" select="ametys:siteParameter('newsletter-enable-tracking')"/>
    
    <xsl:template name="wa-analytics-newsletter">
        <xsl:param name="categoryTitle"/>
        <xsl:param name="title"/>
        <xsl:param name="number"/>
        <xsl:param name="date"/>
        <xsl:param name="categoryRoot">Newsletters</xsl:param>
        
        <xsl:if test="ametys:renderingContext() = 'front'">
            <xsl:variable name="category" select="concat($categoryRoot, '/', $categoryTitle)"/>
            <xsl:variable name="label"><xsl:value-of select="$title" /><xsl:if test="$number != ''"><xsl:value-of select="concat('-', $number)" /></xsl:if><xsl:if test="$date != ''"><xsl:value-of select="concat('-', $date)" /></xsl:if></xsl:variable>
            <xsl:variable name="imageUri" select="wa:eventImageUri(ametys:site(), $category, 'Open', $label)" />
        
            <xsl:if test="$imageUri != ''">
                <img src="{$imageUri}"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="a[@href and not(starts-with(@href, '#'))]">
        <xsl:variable name="sitePrefix" select="ametys:absoluteSiteUriPrefix()"/>
        <xsl:variable name="campaign" select="concat('Newsletters/', $categoryTitle)"/>
        <xsl:variable name="source"><xsl:value-of select="$title" /><xsl:if test="$number != ''"><xsl:value-of select="concat('-', $number)" /></xsl:if><xsl:if test="$date != ''"><xsl:value-of select="concat('-', $date)" /></xsl:if></xsl:variable>
        <xsl:variable name="linkCampaignParams" select="wa:eventLinkCampaignParams(ametys:site(), $campaign, 'email', $source)"/>
                
        <xsl:choose>
            <!-- Links from the newsletter to the site. -->
            <xsl:when test="starts-with(@href, $sitePrefix) and $linkCampaignParams != ''">
                <xsl:copy>
                    <xsl:copy-of select="@*[name() != 'href']"/>
                    <xsl:attribute name="href">
                        <xsl:call-template name="transform-href">
                            <xsl:with-param name="new-params" select="$linkCampaignParams" />
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </xsl:copy>
            </xsl:when>
            <!-- External links. -->
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:copy-of select="@*"/>
                    <xsl:apply-templates/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="transform-href">
        <xsl:param name="new-params"/>
        
        <xsl:choose>
            <xsl:when test="contains(@href, '#') and contains(@href, '?')">
                <xsl:value-of select="substring-before(@href, '#')"/>
                <xsl:text>&amp;</xsl:text>
                <xsl:value-of select="$new-params"/>
                <xsl:text>#</xsl:text>
                <xsl:value-of select="substring-after(@href, '#')"/>
            </xsl:when>
            <xsl:when test="contains(@href, '#')">
                <xsl:value-of select="substring-before(@href, '#')"/>
                <xsl:text>?</xsl:text>
                <xsl:value-of select="$new-params"/>
                <xsl:text>#</xsl:text>
                <xsl:value-of select="substring-after(@href, '#')"/>
            </xsl:when>
            <xsl:when test="contains(@href, '?')">
                <xsl:value-of select="@href"/>
                <xsl:text>&amp;</xsl:text>
                <xsl:value-of select="$new-params"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="@href"/>
                <xsl:text>?</xsl:text>
                <xsl:value-of select="$new-params"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
