/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.queriesdirectory.accesscontroller;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightsException;
import org.ametys.plugins.core.impl.right.AbstractHierarchicalAccessController;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.queriesdirectory.QueryContainer;
import org.ametys.plugins.queriesdirectory.QueryDAO;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class QueryAccessController
extends AbstractHierarchicalAccessController<AmetysObject> {
    public static final I18nizableText QUERIES_DIRECTORY_CONTEXT_CATEGORY = new I18nizableText("plugin.queries-directory", "PLUGINS_QUERIESDIRECTORY_RIGHTS_CATEGORY");
    protected QueryDAO _queryDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._queryDAO = (QueryDAO)((Object)manager.lookup(QueryDAO.ROLE));
    }

    public boolean supports(Object object) {
        return object instanceof Query || object instanceof QueryContainer;
    }

    protected Set<AmetysObject> _getParents(AmetysObject object) {
        AmetysObject parent = object.getParent();
        if (this.supports(parent)) {
            return Collections.singleton(parent);
        }
        return null;
    }

    protected boolean ignoreOnHasAnyPermission() {
        return true;
    }

    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        if (workspacesContexts.contains("/cms")) {
            return Set.of(this._queryDAO.getQueriesRootNode());
        }
        return null;
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        if (object instanceof Query) {
            Map<String, I18nizableText> params = Map.of("title", this.getObjectLabel(object));
            return new I18nizableText("plugin.queries-directory", "PLUGINS_QUERIESDIRECTORY_QUERY_ACCESS_CONTROLLER_QUERY_CONTEXT_LABEL", params);
        }
        if (object instanceof QueryContainer) {
            if (this._queryDAO.getQueriesRootNode().equals(object)) {
                return new I18nizableText("plugin.queries-directory", "PLUGINS_QUERIESDIRECTORY_QUERY_ACCESS_CONTROLLER_ROOT_CONTAINER_CONTEXT_EXPLANATION_LABEL");
            }
            Map<String, I18nizableText> params = Map.of("name", this.getObjectLabel(object));
            return new I18nizableText("plugin.queries-directory", "PLUGINS_QUERIESDIRECTORY_QUERY_ACCESS_CONTROLLER_QUERY_CONTAINER_CONTEXT_LABEL", params);
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Query) {
            Query query = (Query)((Object)object);
            return new I18nizableText(QueryAccessController.getQueryContainerParentPathLabel((QueryContainer)query.getParent()) + query.getTitle());
        }
        if (object instanceof QueryContainer) {
            QueryContainer container = (QueryContainer)((Object)object);
            if (this._queryDAO.getQueriesRootNode().equals(object)) {
                return new I18nizableText("plugin.queries-directory", "PLUGINS_QUERIESDIRECTORY_QUERY_ACCESS_CONTROLLER_ROOT_CONTAINER_CONTEXT_LABEL");
            }
            return new I18nizableText(QueryAccessController.getQueryContainerParentPathLabel((QueryContainer)container.getParent()) + container.getName());
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return QUERIES_DIRECTORY_CONTEXT_CATEGORY;
    }

    public int getObjectPriority(Object object) {
        if (this._queryDAO.getQueriesRootNode().equals(object)) {
            return 10;
        }
        return super.getObjectPriority(object);
    }

    public static String getQueryContainerParentPathLabel(QueryContainer container) {
        AmetysObject ametysObject = container.getParent();
        if (ametysObject instanceof QueryContainer) {
            QueryContainer parent = (QueryContainer)ametysObject;
            return QueryAccessController.getQueryContainerParentPathLabel(parent) + container.getName() + " > ";
        }
        return "";
    }
}

