/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.queriesdirectory;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;


/**
 * {@link AmetysObjectFactory} for handling {@link QueryContainer}s.
 */
public class QueryContainerFactory extends DefaultTraversableAmetysObjectFactory
{
    /** JCR nodetype for query container */
    public static final String QUERY_CONTAINER_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":queries";
    
    /** The Query DAO */
    protected QueryDAO _queryDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _queryDAO = (QueryDAO) manager.lookup(QueryDAO.ROLE);
    }
    
    @Override
    public QueryContainer getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new QueryContainer(node, parentPath, this);
    }
    
    QueryDAO getQueryDAO()
    {
        return _queryDAO;
    }
}
