/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.skincommons;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.path.PathUtils;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class SkinLockManager
extends AbstractLogEnabled
implements Component,
ThreadSafe,
Serviceable {
    public static final String ROLE = SkinLockManager.class.getName();
    private CurrentUserProvider _userProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        this._userProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public boolean canWrite(Path file) throws IOException {
        return this.getLockOwner(file).equals((Object)this._userProvider.getUser());
    }

    public void updateLockFile(Path file, String toolId) throws IOException {
        Path lockFile = file.resolve(".lock");
        if (Files.exists(lockFile, new LinkOption[0])) {
            Files.delete(lockFile);
        }
        String content = UserIdentity.userIdentityToString((UserIdentity)this._userProvider.getUser()) + "\n" + DateUtils.getISODateTimeFormatter().format(ZonedDateTime.now()) + "\n" + toolId;
        Files.writeString(lockFile, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public void unlock(Path file) {
        Path lockFile = file.resolve(".lock");
        if (Files.exists(lockFile, new LinkOption[0])) {
            PathUtils.deleteQuietly((Path)lockFile);
        }
    }

    public boolean isLocked(Path file) {
        Path lockFile = file.resolve(".lock");
        return Files.exists(lockFile, new LinkOption[0]);
    }

    public UserIdentity getLockOwner(Path file) throws IOException {
        Path lockFile = file.resolve(".lock");
        if (!Files.exists(lockFile, new LinkOption[0])) {
            return null;
        }
        List<String> lines = Files.readAllLines(lockFile, StandardCharsets.UTF_8);
        if (!lines.isEmpty()) {
            return UserIdentity.stringToUserIdentity((String)lines.get(0));
        }
        return null;
    }

    public String getLockTool(Path file) throws IOException {
        Path lockFile = file.resolve(".lock");
        if (!Files.exists(lockFile, new LinkOption[0])) {
            return null;
        }
        List<String> lines = Files.readAllLines(lockFile, StandardCharsets.UTF_8);
        if (!lines.isEmpty() && lines.size() > 2) {
            return lines.get(2);
        }
        return null;
    }

    public Date lastModified(Path file) throws IOException {
        Path lockFile = file.resolve(".lock");
        if (!Files.exists(lockFile, new LinkOption[0])) {
            return null;
        }
        List<String> lines = Files.readAllLines(lockFile, StandardCharsets.UTF_8);
        if (!lines.isEmpty() && lines.size() > 1) {
            return Date.from(ZonedDateTime.parse(lines.get(1), DateTimeFormatter.ISO_DATE_TIME).toInstant());
        }
        return null;
    }
}

