/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.skincommons;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.skincommons.SkinEditionHelper;
import org.ametys.plugins.skincommons.SkinLockManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class CheckNotLockedAction
extends ServiceableAction {
    private UserManager _userManager;
    private SkinLockManager _lockManager;
    private SkinEditionHelper _skinHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._lockManager = (SkinLockManager)((Object)smanager.lookup(SkinLockManager.ROLE));
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._skinHelper = (SkinEditionHelper)((Object)smanager.lookup(SkinEditionHelper.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String skinName = request.getParameter("skinName");
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        if (!this._lockManager.canWrite(tempDir)) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            UserIdentity lockOwner = this._lockManager.getLockOwner(tempDir);
            User user = this._userManager.getUser(lockOwner.getPopulationId(), lockOwner.getLogin());
            result.put("isLocked", true);
            result.put("lockOwner", (Boolean)((Object)(user != null ? user.getFullName() + " (" + String.valueOf(lockOwner) + ")" : lockOwner)));
            result.put("success", false);
            request.setAttribute(JSonReader.OBJECT_TO_READ, result);
            return EMPTY_MAP;
        }
        return null;
    }
}

