/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.skincommons;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import org.apache.commons.io.FileUtils;

import org.ametys.core.util.path.PathUtils;

/**
 * Thread for asynchronous file deletion
 *
 */
public class AsynchronousPathDeletion implements Runnable
{
    Path _file;
    
    /**
     * Constructor
     * @param file The file to delete
     */
    public AsynchronousPathDeletion (Path file)
    {
        _file = file;
    }
    
    @Override
    public void run()
    {
        if (_file != null)
        {
            try
            {
                if (Files.isDirectory(_file))
                {
                    PathUtils.deleteDirectory(_file);
                }
                else 
                {
                    Files.deleteIfExists(_file);
                }
            }
            catch (IOException e)
            {
                // Emtpy
                try
                {
                    // There is no deleteOnExit for path... switching to File since we know we are working on default file system here
                    File f = _file.toFile();
                    FileUtils.forceDeleteOnExit(f);
                }
                catch (IOException uoe)
                {
                    // Nothing
                }
            }
            
        }

    }

}
