/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.skineditor.resources;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;

import org.ametys.core.cocoon.JSonReader;

/**
 * This action creates or updates a resource file.
 */
public class AddOrUpdateFileAction extends ServiceableAction
{
    /** Constant for skin editor tool id */
    public static final String SKIN_EDITOR_TOOL_ID = "uitool-skineditor";
    
    /** The skin edition helper */
    protected SkinResourceDAO _skinResourceDAO;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _skinResourceDAO = (SkinResourceDAO) smanager.lookup(SkinResourceDAO.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String path = request.getParameter("parentPath");
        
        boolean unzip = Boolean.valueOf(request.getParameter("unzip"));
        String mode = parameters.getParameter("mode", "add");
        
        Part part = (Part) request.get("filename");
        
        Map<String, Object> result = _skinResourceDAO.addOrUpdateFile(source, part, path, mode, unzip);
        
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

}
