/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.skineditor.skin;

import java.util.ArrayList;
import java.util.Map;

import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;

import org.ametys.plugins.core.ui.parameter.files.AbstractGetFilesAction;

/**
 * Action to get child files and folder of a skin directory
 *
 */
public class GetTempSkinResourcesAction extends AbstractGetFilesAction
{
    static final String[] __IGNORED_SOURCE = new String[] {".svn", ".cvs", ".lock", "CVS"};
    
    @Override
    protected String getRootURI(Request request)
    {
        String skinName = request.getParameter("skinName");
        return "ametys-home://skins/temp/" + skinName;
    }
    
    @Override
    protected boolean isIgnoredSource(TraversableSource source)
    {
        return ArrayUtils.contains(__IGNORED_SOURCE, source.getName());
    }
    
    @Override
    protected Map<String, Object> _collection2JsonObject(TraversableSource folder, TraversableSource root)
    {
        Map<String, Object> object = super._collection2JsonObject(folder, root);
        object.put("skinName", root.getName());
        
        try
        {
            if (folder.getChildren().size() == 0)
            {
                object.put("nodes", new ArrayList<>());
            }
        }
        catch (SourceException e)
        {
            getLogger().warn("Unable to list the children of the folder '" + folder.getURI() + "'.", e);
        }
        
        return object;
    }
    
    @Override
    protected Map<String, Object> _resource2JsonObject(TraversableSource file, TraversableSource root)
    {
        Map<String, Object> object = super._resource2JsonObject(file, root);
        object.put("skinName", root.getName());
        return object;
    }
}
