/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.skineditor.resources;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.ametys.core.file.FileHelper;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.skincommons.SkinEditionHelper;
import org.ametys.plugins.skincommons.SkinLockManager;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;

public class SkinResourceDAO
implements Serviceable,
Component {
    public static final String ROLE = SkinResourceDAO.class.getName();
    public static final String SKIN_EDITOR_TOOL_ID = "uitool-skineditor";
    private static final List<String> __IGNORED_SOURCE = List.of(".svn", ".cvs", ".lock", "CVS", ".gitignore");
    protected SkinLockManager _lockManager;
    protected SkinEditionHelper _skinHelper;
    protected FileHelper _fileHelper;
    protected SourceResolver _srcResolver;
    protected CurrentUserProvider _currentUserProvider;
    protected RightManager _rightManager;
    protected SkinsManager _skinManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._skinHelper = (SkinEditionHelper)manager.lookup(SkinEditionHelper.ROLE);
        this._skinManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._fileHelper = (FileHelper)manager.lookup(FileHelper.ROLE);
        this._lockManager = (SkinLockManager)manager.lookup(SkinLockManager.ROLE);
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getFiles(String skinName, String path) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        List files = this._fileHelper.getFiles(tempDirURI, path, __IGNORED_SOURCE);
        files.stream().forEach(file -> file.put("skinName", skinName));
        return files;
    }

    @Callable(rights={""})
    public Map<String, Object> save(String skinName, String relPath, String text) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        String fileURI = tempDirURI + (String)(relPath.length() > 0 ? "/" + relPath : "");
        Map result = this._fileHelper.saveFile(fileURI, text);
        if (result.containsKey("isI18n")) {
            this._skinHelper.invalidateTempSkinCatalogues(skinName);
        }
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        this._lockManager.updateLockFile(tempDir, SKIN_EDITOR_TOOL_ID);
        return result;
    }

    @Callable(rights={""})
    public boolean checkSourceExists(String skinName, String parentRelPath, String fileName) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        String parentFileURI = tempDirURI + (String)(parentRelPath.length() > 0 ? "/" + parentRelPath : "");
        return this._fileHelper.hasChild(parentFileURI, fileName);
    }

    @Callable(rights={""})
    public Map<String, Object> copySource(String skinName, String srcPath, String parentTargetPath) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        String srcFileURI = tempDirURI + (String)(srcPath.length() > 0 ? "/" + srcPath : "");
        String parentTargetURI = tempDirURI + (String)(parentTargetPath.length() > 0 ? "/" + parentTargetPath : "");
        Map result = this._fileHelper.copySource(srcFileURI, parentTargetURI);
        FileSource rootDir = (FileSource)this._srcResolver.resolveURI(tempDirURI);
        this._lockManager.updateLockFile(rootDir.getFile().toPath(), SKIN_EDITOR_TOOL_ID);
        if (result.containsKey("uri")) {
            String folderUri = (String)result.get("uri");
            String path = folderUri.substring(rootDir.getURI().length());
            result.put("path", path.endsWith("/") ? path.substring(0, path.length() - 1) : path);
            result.put("skinName", skinName);
        }
        return result;
    }

    @Callable(rights={""})
    public Map addFolder(String skinName, String parentRelPath, String originalName, boolean renameIfExists) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        String parentURI = tempDirURI + (String)(parentRelPath.length() > 0 ? "/" + parentRelPath : "");
        Map result = this._fileHelper.addFolder(parentURI, originalName, renameIfExists);
        FileSource rootDir = (FileSource)this._srcResolver.resolveURI(tempDirURI);
        this._lockManager.updateLockFile(rootDir.getFile().toPath(), SKIN_EDITOR_TOOL_ID);
        if (result.containsKey("uri")) {
            String folderUri = (String)result.get("uri");
            String path = folderUri.substring(rootDir.getURI().length());
            result.put("path", path.endsWith("/") ? path.substring(0, path.length() - 1) : path);
            result.put("parentPath", parentRelPath.endsWith("/") ? parentRelPath.substring(0, parentRelPath.length() - 1) : parentRelPath);
            result.put("skinName", skinName);
        }
        return result;
    }

    @Callable(rights={""})
    public Map addOrUpdateFile(String skinName, Part part, String toPath, String mode, boolean unzip) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        FileSource tempDir = (FileSource)this._srcResolver.resolveURI(tempDirURI);
        String parentURI = tempDirURI + (String)(toPath.length() > 0 ? "/" + toPath : "");
        FileSource parentDir = (FileSource)this._srcResolver.resolveURI(parentURI);
        Map result = this._fileHelper.addOrUpdateFile(part, parentDir, mode, unzip);
        this._lockManager.updateLockFile(tempDir.getFile().toPath(), SKIN_EDITOR_TOOL_ID);
        if (result.containsKey("uri")) {
            String fileUri = (String)result.get("uri");
            String filePath = fileUri.substring(tempDir.getURI().length());
            result.put("path", filePath.endsWith("/") ? filePath.substring(0, filePath.length() - 1) : filePath);
            String parentPath = parentDir.getURI().substring(tempDir.getURI().length());
            result.put("parentPath", parentPath.endsWith("/") ? parentPath.substring(0, parentPath.length() - 1) : parentPath);
        } else if (result.containsKey("unzip")) {
            String parentPath = parentDir.getURI().substring(tempDir.getURI().length());
            result.put("parentPath", parentPath.endsWith("/") ? parentPath.substring(0, parentPath.length() - 1) : parentPath);
        }
        return result;
    }

    @Callable(rights={""})
    public Map deleteFile(String skinName, String relPath) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        String fileURI = tempDirURI + (String)(relPath.length() > 0 ? "/" + relPath : "");
        Map result = this._fileHelper.deleteFile(fileURI);
        Path tempDir = this._skinHelper.getTempDirectory(skinName);
        this._lockManager.updateLockFile(tempDir, SKIN_EDITOR_TOOL_ID);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> moveSource(String skinName, String srcPath, String targetPath) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        String srcFileURI = tempDirURI + (String)(srcPath.length() > 0 ? "/" + srcPath : "");
        String parentTargetURI = tempDirURI + (String)(targetPath.length() > 0 ? "/" + targetPath : "");
        Map result = this._fileHelper.moveSource(srcFileURI, parentTargetURI);
        FileSource rootDir = (FileSource)this._srcResolver.resolveURI(tempDirURI);
        this._lockManager.updateLockFile(rootDir.getFile().toPath(), SKIN_EDITOR_TOOL_ID);
        if (result.containsKey("uri")) {
            String folderUri = (String)result.get("uri");
            String path = folderUri.substring(rootDir.getURI().length());
            result.put("path", path.endsWith("/") ? path.substring(0, path.length() - 1) : path);
            result.put("skinName", skinName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={""})
    public Map renameSource(String skinName, String relPath, String name) throws IOException {
        this._checkUserRight(skinName);
        String tempDirURI = this._skinHelper.getTempDirectoryURI(skinName);
        String fileURI = tempDirURI + (String)(relPath.length() > 0 ? "/" + relPath : "");
        Map result = this._fileHelper.renameFile(fileURI, name);
        FileSource rootDir = null;
        try {
            rootDir = (FileSource)this._srcResolver.resolveURI(tempDirURI);
            this._lockManager.updateLockFile(rootDir.getFile().toPath(), SKIN_EDITOR_TOOL_ID);
        }
        finally {
            this._srcResolver.release((Source)rootDir);
        }
        if (result.containsKey("uri")) {
            String newURI = (String)result.get("uri");
            String path = newURI.substring(rootDir.getURI().length());
            result.put("path", path);
            result.put("name", name);
            result.put("skinName", skinName);
        }
        return result;
    }

    private void _checkUserRight(String skinName) throws IllegalStateException {
        UserIdentity user = this._currentUserProvider.getUser();
        Skin skin = this._skinManager.getSkin(skinName);
        if (skin == null) {
            throw new IllegalStateException("User '" + String.valueOf(user) + "' tried to modify an unknown skin '" + skinName + "'");
        }
        if (!skin.isModifiable()) {
            throw new IllegalStateException("User '" + String.valueOf(user) + "' tried to modify an unmodifiable skin '" + skinName + "'");
        }
        if (!(this._rightManager.hasRight(user, "Plugins_SkinEditor_EditAllSkin", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.hasRight(user, "Plugins_SkinEditor_EditCurrentSkin", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW && skinName.equals(this._skinManager.getSkinNameFromRequest()))) {
            throw new IllegalStateException("User '" + String.valueOf(user) + "' tried to modify skin '" + skinName + "' without convenient right.");
        }
    }
}

